#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <mpi.h>
#include "my_lib.h"

int main(int argc, char *argv[]){

    int mypnum, nprocs, npcol, nprow, myprow, mypcol; 
    int val, icontxt;
    char *order = "R";

    MPI_Init(&argc,&argv);

    Cblacs_pinfo(&mypnum, &nprocs);

    nprow = (int) (sqrt(nprocs+0.1));
    npcol = nprocs / nprow;

    printf("\n\tMYPE %d, NPE %d, NPE ROW %d, NPE COL %d\n", mypnum, nprocs, nprow, npcol);

    
    Cblacs_get(-1, 0, &icontxt);

    Cblacs_gridinit(&icontxt, order, nprow, npcol);

    Cblacs_gridinfo(icontxt, &nprow, &npcol, &myprow, &mypcol);

    printf("\n\tmy id =  %d, my row =  %d, my col = %d", mypnum, myprow, mypcol);

    Cblacs_barrier(icontxt, "A");
    
    Cblacs_gridexit(icontxt);


    if(mypnum==0) printf("\n\t... end.\n");
    
    /* MPI_Finalize(); */

    Cblacs_exit(0);

    return 1;

}
    
