program hello
  implicit none
  include 'mpif.h'
  
  integer ierr,me,nprocs
  integer status(MPI_STATUS_SIZE)

! data buffer must be large enough to get deadlock
  integer,parameter :: ndata = 10000
  real :: a(ndata)
  real :: b(ndata)

  call MPI_INIT(ierr)
  call MPI_COMM_SIZE(MPI_COMM_WORLD, nprocs, ierr)
  call MPI_COMM_RANK(MPI_COMM_WORLD, me, ierr)

  a = me

  if (nprocs /= 2) then
     print *,'This program must run on 2 processors'
     call MPI_ABORT(ierr)
     stop
  endif
  if (me==0) then
     call MPI_SEND(a,ndata,MPI_REAL,1,0,MPI_COMM_WORLD,ierr)
     call MPI_RECV(b,ndata,MPI_REAL,1,0,MPI_COMM_WORLD,status,ierr)
  else
     call MPI_SEND(a,ndata,MPI_REAL,0,0,MPI_COMM_WORLD,ierr)
     call MPI_RECV(b,ndata,MPI_REAL,0,0,MPI_COMM_WORLD,status,ierr)
  endif

  print *,'I am proc ',me,' and I have received b(1) = ',b(1)
  call MPI_FINALIZE(ierr)
  
end program hello
