program hello
  implicit none
  include 'mpif.h'
  
  integer ierr,me,nprocs,left,right
  integer status(MPI_STATUS_SIZE)

  integer,parameter :: ndata = 1000
  
  real :: a
  real :: b
  real :: somma

  integer i

  call MPI_INIT(ierr)
  call MPI_COMM_SIZE(MPI_COMM_WORLD, nprocs, ierr)
  call MPI_COMM_RANK(MPI_COMM_WORLD, me, ierr)

  a = me
  b = -1

  right = mod(me + 1 , nprocs)
  left =  mod(me - 1 + nprocs , nprocs)


  somma = a

  do i = 1,nprocs-1
     call MPI_SENDRECV(a,1,MPI_REAL,left,0, &
          b,1,MPI_REAL,right,0,MPI_COMM_WORLD,status,ierr)
     a = b
     somma = somma + a
  enddo

  print *,'I am proc ',me,' and somma = ',somma
  call MPI_FINALIZE(ierr)
  
end program hello
