      PROGRAM blacs_test
!
!     BLACS testing program
!     this program tests BLACS basic functionalities
!
!     Carlo Cavazzoni ( c.cavazzoni@cineca.it ), 
!     High Performance Computing Group - CINECA
!

      IMPLICIT NONE

!     .. Local Scalars ..
      INTEGER            :: context, iam, mycol, myrow,
     $                   npcol, nprocs, nprow
!
      !     Initialize the BLACS
!
      CALL BLACS_PINFO( iam, nprocs )

      !     Set the dimension of the 2D processors grid 

      nprow = INT( sqrt( nprocs + 0.1d0 ) )
      npcol = nprocs / nprow
!      nprow = 1
!      npcol = 2

      write (*,100) iam, nprocs, nprow, npcol
100   format(' MYPE ',I3,', NPE ',I3,', NPE ROW ',I3,', NPE COL ',I3) 

      !     Get a default BLACS context
!
      CALL BLACS_GET( -1, 0, context )

      !     Initialize a default BLACS context

      CALL BLACS_GRIDINIT( context, 'R', nprow, npcol )

      !     Given a context, return grid dimensions and row and column index

      CALL BLACS_GRIDINFO( context, nprow, npcol, myrow, mycol )

      !
      WRITE( 6, 10 ) iam, myrow, mycol
 10   FORMAT( 'my id = ', I2, ' my row = ', I2, ' my com = ', I2 )

      IF( mycol .gt. -1 .and. myrow .gt. -1 ) then
        CALL BLACS_BARRIER ( context, 'A')
      endif
!
      IF( mycol .gt. -1 .and. myrow .gt. -1 ) then
        CALL BLACS_GRIDEXIT( context )
      endif
!
      CALL BLACS_EXIT( 0 )
!
      STOP
      END
