#include "mpi.h"
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define N 10

/*typedef int row[N];*/

int main(int argc, char *argv[])
{
  int np, rank, n, r;
  int I;
  int i,j;
  int k;
  int **mat;
  MPI_Status status;
  
  MPI_Init(&argc,&argv);
  MPI_Comm_size(MPI_COMM_WORLD,&np);
  MPI_Comm_rank(MPI_COMM_WORLD,&rank);
  

  n = N / np;
  r = N % np;
  if (rank < r)
    n++;

  mat = malloc(n*sizeof(int*));  
  for(i=0; i<n; i++){
   mat[i] = malloc(N*sizeof(int));
  }
  
  I = n*rank;
  if (rank >= r)
    I += r;

  for (i=0; i < n; i++)
  {
    for (j=0; j<N; j++)
      if (j == I)
        mat[i][j] = 1;
      else
        mat[i][j] = 0;    
    I++;
  }
  
  if (rank == 0)
  {   
    for (i=0; i<n; i++)
    {
      for (j=0; j<N; j++)
        printf("%d ", mat[i][j]);
      printf("\n");
    } 

    for (k=1; k < np; k++)
    {
	if(k==r){
	    n = n -1;
	}
	MPI_Recv(mat, n*N, MPI_INT, k, 0, MPI_COMM_WORLD, &status);
	for (i=0; i < n; i++)
	{
	    for (j=0; j<N; j++)
		printf("%d ", mat[i][j]);
	    printf("\n");
	} 
	
    }
  }
  else
      MPI_Send(mat, n*N, MPI_INT, 0, 0, MPI_COMM_WORLD);
  
  
  MPI_Finalize();  
}
