#ifndef _MY_LIB_H_
#define _MY_LIB_H_

typedef struct{

    int mypnum;
    int nprocs;
    int npcol;
    int nprow;
    int mypcol;
    int myprow;
    int icontxt;

}pcom_data;

typedef struct{
    int lenght;
    int *array;
}convform;

#if defined __AIX

#define numroc_ numroc
#define descinit_ descinit
#define pdelset_ pdelset
#define wrapperc2f_ wrapperc2f
#define indxl2g_ indxl2g
#define pdgemm_ pdgemm
#define pdsyev_ pdsyev

#endif

void Cpdlaprnt(int *m, int *n, double *a, int *ia, int *ja, int *desca, int *irprnt, int *icprnt, char *cmatnm, int *nout, double *work);



/*
 * Blacs function
 */
extern void Cblacs_pinfo(int *mypnum, int *nprocs);
extern void Cblacs_exit(int doneblag);
extern void Cblacs_get(int icontxt, int what, int *val); 
extern void Cblacs_gridinit(int *icontxt, char *order, int nprow, int npcol);
extern void Cblacs_gridinfo(int icontxt, int *nprow, int *npcol, int *myprow, int *mypcol);
extern void Cblacs_barrier(int icontxt, char *scope);
extern void Cblacs_gridexit(int icontxt);

/*
 * Scalapack function 
 */
extern int numroc_(int *n, int *nb, int *iproc, int *isrcproc, int *nprocs);
extern void descinit_(int *desc, int *m, int *n, int *mb, int *nb, int *irsrc, int *icsrc, int *ictxt, int *lld, int *info);
extern void pdelset_(double *a, int *ia, int *ja, int *desca, double *alpha);
extern void wrapperc2f_(int *m, int *n, double *a, int *ia, int *ja, int *desca, int *irprnt, int *icprnt, int *lenght, int *array, int *nout, double *work);
extern int indxl2g_(int *indxloc, int *nb, int *iproc, int *isrcproc, int *nprocs);
extern void pdgemm_(char *transa, char *transb, int *m, int *n, int *k, double *alpha, double *a, int *ia, int *ja, int *desca, double *b, int *ib, int *jb, int *descb, double* beta, double *c, int *ic, int *jc, int *descc);

/*
 * Mkl function
 */
extern void pdsyev_(char *jobz, char *uplo, int *n, double *a, int *ia, int *ja, int *desca, double *w, double *z, int *iz, int *jz, int *descz, double *work, int *lwork, int *info);


extern double cclock_();

#endif _MY_LIB_H_
