

#include <stdio.h>
#include <rpc/rpc.h>
#include "ahhead.h"

char	*progname;

main(argc,argv)		/*	ah2asc:		ah format -> ascii	*/
int	argc;
char	**argv;
{
	FILE	*file_in;

/*		functions:	

	char	*strcpy();
	FILE	*fopen();*/

	progname= argv[0];

	if(argc == 1)	/* no args;	use stdin	*/
		record2ascii(stdin,stdout);
	else
		while(--argc > 0)
		{
			if((file_in = fopen(*++argv,"r")) == NULL)
			{
				fprintf(stderr,"%s:  can't open %s\n",progname,*argv);
				exit(-2);
			}
			else
			{
				record2ascii(file_in,stdout);
				fclose(file_in);
			}
		}	/*	end while	*/
	exit(0);
}



/*	record2ascii
 *		converts ah record (header + data) to ascii format
 *	returns:
 *			NO RETURNS -- exit(-1) if not enough space
 */
 int	record2ascii(file_in,file_out)

		FILE	*file_in,*file_out;
{
		XDR	xdr_in;
		ahhed	head;
		int		i;
		long	nbytes, n;
		float	*fptr;
		double	*dptr;
		char	*array;

		char	*malloc();
/*		char	*sprintf();*/


	xdrstdio_create(&xdr_in, file_in, XDR_DECODE);

	while(xdr_gethead(&head, &xdr_in) > 0)
	{

		head.station.code[5]= '\0';
		head.station.chan[5]= '\0';
		head.station.stype[7]= '\0';
		head.event.ecomment[79]= '\0';
		head.record.rcomment[79]= '\0';
		head.record.log[LOGSIZE-1]= '\0';

		if(strlen(head.station.code) == 0)
			sprintf(head.station.code,"null");

		if(strlen(head.station.chan) == 0)
			sprintf(head.station.chan,"null");

		if(strlen(head.station.stype) == 0)
			sprintf(head.station.stype,"null");

		if(strlen(head.event.ecomment) == 0)
			sprintf(head.event.ecomment,"null");

		if(strlen(head.record.rcomment) == 0)
			sprintf(head.record.rcomment,"null");

		if(strlen(head.record.log) == 0)
			sprintf(head.record.log,"null;");

		fprintf(file_out,"station information\n");	/* station info	*/
		fprintf(file_out,"code:\t%s\n",head.station.code);
		fprintf(file_out,"channel:\t%s\n",head.station.chan);
		fprintf(file_out,"type:\t%s\n",head.station.stype);
		fprintf(file_out,"latitude:\t%f\n",head.station.slat);
		fprintf(file_out,"longitude:\t%f\n",head.station.slon);
		fprintf(file_out,"elevation:\t%f\n",head.station.elev);
		fprintf(file_out,"gain:\t%f\n",head.station.DS);
		fprintf(file_out,"normaliztion:\t%f\n",head.station.A0);
		fprintf(file_out,"calibration information\n");
		fprintf(file_out,"pole.re\t\tpole.im\t\tzero.re\t\tzero.im\n");
		for(i=0; i<NOCALPTS; ++i)
			fprintf(file_out,"%e\t%e\t%e\t%e\n",head.station.cal[i].pole.r,head.station.cal[i].pole.i,head.station.cal[i].zero.r,head.station.cal[i].zero.i);
	
		fprintf(file_out,"event information\n");	/* event info	*/
		fprintf(file_out,"latitude:\t%f\n",head.event.lat);
		fprintf(file_out,"longitude:\t%f\n",head.event.lon);
		fprintf(file_out,"depth:\t%f\n",head.event.dep);
		fprintf(file_out,"origin_time:\t%d\t%d\t%d\t%d\t%d\t%f\n",head.event.ot.yr,
			head.event.ot.mo,head.event.ot.day,head.event.ot.hr,head.event.ot.mn,head.event.ot.sec);
		fprintf(file_out,"comment:\t%s\n",head.event.ecomment);
	
		fprintf(file_out,"record information\n");	/* record info	*/
		fprintf(file_out,"type:\t%d\n",head.record.type);
		fprintf(file_out,"ndata:\t%ld\n",head.record.ndata);
		fprintf(file_out,"delta:\t%e\n",head.record.delta);
		fprintf(file_out,"max_amplitude:\t%e\n",head.record.maxamp);

		fprintf(file_out,"start_time:\t%d\t%d\t%d\t%d\t%d\t%f\n",head.record.abstime.yr,
			head.record.abstime.mo,head.record.abstime.day,head.record.abstime.hr,
			head.record.abstime.mn,head.record.abstime.sec);
		fprintf(file_out,"abscissa_min:\t%e\n",head.record.rmin);
		fprintf(file_out,"comment:\t%s\n",head.record.rcomment);
		fprintf(file_out,"log:\t%s\n",head.record.log);

		fprintf(file_out,"extras:\n");
		for(i=0; i<NEXTRAS; ++i)
			fprintf(file_out,"%d:\t%e\n",i,head.extra[i]);
	
		fprintf(file_out,"data:\n");
		nbytes = (head.record.ndata)*size(&head);
		if((array= malloc((unsigned)nbytes)) == NULL)
			exit(-1);			/* not enough space	*/

		xdr_getdata(&head, array, &xdr_in);	

		n= head.record.ndata;

		switch(head.record.type)
		{
		case FLOAT:			/* floats	*/
			fptr= (float *)array;
			while( n-- )
			{
				fprintf( file_out, "%e\n", *fptr );
				++fptr;
			}
			break;
	
		case COMPLEX:			/* complex	*/
		case VECTOR:			/* real x,y pairs	*/
			fptr= (float *)array;
			while( n-- )
			{
				fprintf( file_out, "%e\t%e\n", *fptr, *(fptr+1) );
				fptr += 2;
			}
			break;
	
		case TENSOR:			/* x real, y complex	*/
			fptr= (float *)array;
			while( n-- )
			{
				fprintf( file_out, "%e\t%e\t%e\n", *fptr, *(fptr+1), *(fptr+2) );
				fptr += 3;
			}
			break;
	
		case 5:			/* complex x,y pairs	*/
			fptr= (float *)array;
			while( n-- )
			{
				fprintf( file_out, "%e\t%e\t%e\t%e\n", *fptr, *(fptr+1), *(fptr+2), *(fptr+3) );
				fptr += 4;
			}
			break;

		case DOUBLE:			/* doubles	*/
			dptr= (double *)array;
			while( n-- )
			{
				fprintf( file_out, "%e\n", *dptr );
				++dptr;
			}
			break;
	
		}				/*	end switch	*/
		free((char *)array);
	}		/*	end while	*/
}
