/* This program takes to timeseries and either convolves, adds, subtracts, or multiplies
 *	them together.  If the absolute timing of the records is important,
 *	this routine will adjust the timeseries as necessary to insure they
 *	start at the same time and are sampled at identical times.
 *
 *				Error conditions;
 *					-1 = Error in command line input
 *					-2 = Error allocating array space
 *					-3 = Error reading input data
 *					-4 = Error writing output
 *					-8 = Data sets do not overlap in time
 *					-9 = Data sets not sampled with same dt
 *
 *			Latest Revision; Jan 8, 1986
 *				By; Tom Boyd
 *                      Added data set subtract feature; July 28, 1986
 *                              By; Art Lerner-Lam
 *                      Updated to read and write xdr ahf files; September 19, 1989
 *                              By; Ken Howard
 */
#include <stdio.h>
#include <rpc/rpc.h>
#include <math.h>
#include "ahhead.h"

char *progname;
main (argc,argv)
int argc;
char *argv[];
{

	XDR xdr_stdin, xdr_filein, xdr_stdout;
	ahhed head_1,head_2;
	FILE *fopen(),*file1;
	static char strng[15]={'c','o','n','a','d','d','-','\0'};
	char operation,real_time='n',*calloc();
	char only_first='n',first_record='y';
	float *result,*data_1,*data_2,*data_3,*data_4,temp;
	float inc_diff,diff,*t_fold(),*t_add(),*t_sub(),*t_mult(),*f_mult(),*f_div();
	double epoch_1,epoch_2,htoe();
	complex *f_fold(),*f_add();
	int i,length_1,length_2,int_diff;

	progname=argv[0];
	if((argc<4)||(out_is_tty()!=0)||(in_is_tty()!=0))
	{
		fprintf(stderr,"Usage: %s -[Help] -cfdmas -[o] -[t] -n file1  < stdin > stdout\n",progname);
		if(argc >= 2)
		{
		if(*(argv[1]+1) == 'H')
		{
			fprintf(stderr,"\n-c = convolve file1 with stdin");
			fprintf(stderr,"\n-f = circular convolution of file1 with stdin");
			fprintf(stderr,"\n-d = deconvolve file1 from stdin");
			fprintf(stderr,"\n-m = multiply file1 with stdin\n");
			fprintf(stderr,"-a = add file1 with stdin\n");
			fprintf(stderr,"-s = subtract stdin from file1\n");
			fprintf(stderr,"-o = use first dataset in file1 on each\n");
			fprintf(stderr,"     dataset in stdin, otherwise datasets\n");
			fprintf(stderr,"     in each file used sequentially\n");
			fprintf(stderr,"-t = adjust datasets by their real times\n");
			fprintf(stderr,"	NOTE--Multiplexing interval not removed\n");
			fprintf(stderr,"-n = input file flag for file1\n");
		}
		}
		exit (-1);
	}

	for(i=1;i<argc;i++)
	{
		if(*(argv[i]) == '-')
		{
			switch (*(argv[i]+1))
			{
				case 'c':
					operation='c';
					break;
				case 'f':
					operation='f';
					break;
				case 'd':
					operation='d';
					break;
				case 'm':
					operation='m';
					break;
				case 'a':
					operation='a';
					break;
		                case 's':
					operation='s';
					break;
				case 'o':
					only_first='y';
					break;
				case 't':
					real_time='y';
					break;
				case 'n':
					if((file1=fopen(argv[i+1],"r+")) == NULL)
					{
						fprintf(stderr,"Error in %s: trying to open %s as file1\n",progname,argv[i+1]);
						exit(-1);
					}
					i++;
					xdrstdio_create(&xdr_filein, file1, XDR_DECODE);
					break;
				default:
					fprintf(stderr,"Error in command line to program %s: type '%s -H' for help\n",progname,progname);
					exit(-1);
			}
		}
		else
		{
			fprintf(stderr,"Error in command line to program %s: type '%s -H' for help \n",progname,progname);
			exit(-1);
		}
	}

	
	/* create stdin and stdout xdr streams */
	xdrstdio_create(&xdr_stdin, stdin, XDR_DECODE);
	xdrstdio_create(&xdr_stdout, stdout, XDR_ENCODE);

/* loop through two data files */

	while(xdr_gethead(&head_2, &xdr_stdin) == 1)
	{

	/* read from file1; if necessary */

		if((only_first == 'n') || (first_record == 'y'))
		{
			if(xdr_gethead(&head_1, &xdr_filein) != 1) exit(0); /* EOF */
		}

		/* make sure data are sampled with same dt */

		if(head_1.record.delta != head_2.record.delta)
		{
			fprintf(stderr,"Error in %s: data not sampled with same dt\n",progname);
			exit(-9);
		}

		/* get data lengths */

		length_1=head_1.record.ndata;
		length_2=head_2.record.ndata;

		/* for a circular convolution data lengths must be a power of 2 */
	
		if((operation == 'f') || (operation == 'd'))
		{
			for(i=1;((int)pow((double)2,(double)i)) < length_1;++i);
			length_1=(int)pow((double)2,(double)i);
			for(i=1;((int)pow((double)2,(double)i)) < length_2;++i);
			length_2=(int)pow((double)2,(double)i);
		}


		/*  make length_1=length_2 if necessary */

		/*if((operation == 'a') || (operation == 'f') || (operation == 's') ||
			(operation == 'd'))
		{
			if(length_2 > length_1)length_1=length_2;
			if(length_1 > length_2)length_2=length_1;
		}*/

		/* allocate array space and read data from file1; if necessary */

		if((only_first == 'n')||(first_record == 'y'))
		{
			if((data_1=(float *)calloc((unsigned)(length_1+2),sizeof(float))) == NULL)
			{
				fprintf(stderr,"Error allocating space for file1 in %s\n",progname);
				exit(-2);
			}
			if(xdr_getdata(&head_1,data_1, &xdr_filein) == 0)
			{
				fprintf(stderr,"Error reading data in file1 in %s\n",progname);
				exit(-3);
			}
		}

		/* allocate array space and read data from stdin */

		if((data_2=(float *)calloc((unsigned)(length_2+2),sizeof(float))) == NULL)
		{
			fprintf(stderr,"Error allocating space for stdin in %s\n",progname);
			exit(-2);
		}
		if(xdr_getdata(&head_2,data_2, &xdr_stdin) == 0)
		{
			fprintf(stderr,"Error reading data from stdin in %s\n",progname);
			exit(-3);
		}

		/* if absolute timing should be used correct traces for it; if necessary */

		if((real_time == 'y') && ((operation == 'a')||(operation == 'm')))
		{
			/* get epoch start times in seconds */

			epoch_1=htoe(&head_1.record.abstime);
			epoch_2=htoe(&head_2.record.abstime);
			diff=(float)(epoch_2-epoch_1);
			inc_diff=fabs(diff/head_1.record.delta-(int)(diff/head_1.record.delta));
			inc_diff*=head_1.record.delta; /* sample timing difference */
			if(inc_diff > 0.5)inc_diff-=1.0; /* reference to nearest sample -0.5 <= inc_diff <= 0.5 */

			/* check to see if data sets overlap in time */

			if(((diff > 0) && (diff > head_1.record.delta*length_1)) || ((diff < 0) && ((-1.0*diff) > head_2.record.delta*length_2)))
			{
				fprintf(stderr,"Error in %s: data sets do not overlap in time\n");
				exit(-8);
			}
		}
		if((real_time == 'y') && ((operation == 'a') || (operation == 's') || (operation == 'm'))) 
		/* traces must start at same time also */
		{
			int_diff=(int)(diff/head_1.record.delta); /* number of sample intervals difference */
			if(int_diff > 0) /* stdin starts after file1 */
			length_2=length_2+int_diff;
			{
                        if((data_3=(float *)calloc((unsigned)(length_2+2),sizeof(float))) == NULL)
                                {
                                 fprintf(stderr,"Error allocating space for file1 in %s\n",progname);
                                 exit(-2);
                                }
                        if((data_4=(float *)calloc((unsigned)(length_2+2),sizeof(float))) == NULL)
                                {
                                 fprintf(stderr,"Error allocating space for file1 in %s\n",progname);
                                 exit(-2);
                                }

				if(inc_diff <0)int_diff++;
				for(i=0;i<length_2;i++) 
				{
                                        if(i < length_1)data_3[i]=data_1[i];
                                        if(i >= length_1)data_3[i]=0.;
                                        if(i < int_diff)data_4[i]=0.;
                                        if(i >= int_diff)data_4[i]=data_2[i-int_diff-1];
				}
				etoh(&head_2.record.abstime,epoch_1);
				head_2.record.rmin=head_2.record.abstime.sec;
			}
			if(int_diff < 0) /* stdin starts before file1 */
			{
				if(inc_diff < 0)inc_diff++; 
				for(i=0;i<length_2;i++) /*shift stdin to file1 start */
				{
					if(i-int_diff < length_2)data_2[i]=data_2[i-int_diff+1];
				}
				etoh(&head_2.record.abstime,epoch_1);
				head_2.record.rmin=head_2.record.abstime.sec;
				int_diff*=(-1.0);
			}
				
		}

		/* now do the apporpriate data processing */

		switch(operation)
		{
			case 'c':
				result=t_fold(data_1,length_1,data_2,length_2);
				head_2.record.ndata=length_1+length_2-1;
				strncat(strng,"c;",2);
				logger(strng,&head_2);
				maxamp (&head_2,result);
				break;
			case 'f':
				if((only_first == 'n') || (first_record == 'y')) cfftr(data_1,length_1);
				cfftr(data_2,length_2);
				result=f_mult(data_2,data_1,length_2);
				cfftri(result,length_2);
				for(i=0;i<length_2;i++)result[i]*=(2.0/length_2);
				head_2.record.ndata=length_2;
				strncat(strng,"d;",2);
				logger(strng,&head_2);
				maxamp (&head_2,result);
				break;
			case 'd':
				if((only_first == 'n') || (first_record == 'y')) cfftr(data_1,length_1);
				cfftr(data_2,length_2);
				result=f_div(data_1,data_2,length_2);
				cfftri(result,length_2);
				for(i=0;i<length_2;i++)result[i]*=(2.0/length_2);
				head_2.record.ndata=length_2;
				strncat(strng,"f;",2);
				logger(strng,&head_2);
				maxamp (&head_2,result);
				break;
			case 'm':
				result=(float *)t_mult(data_1,data_2,length_1);
				/* get output data length right */
				if(head_2.record.ndata > head_1.record.ndata)head_2.record.ndata=head_1.record.ndata;
				head_2.record.ndata-=int_diff;
				strncat(strng,"m",1);
				if(real_time == 'y')strncat(strng,"t",1);
				strncat(strng,";",1);
				logger(strng,&head_2);
				maxamp (&head_2,result);
				break;
			case 'a':
				result=t_add(data_3,data_4,length_2);
				/* get output data length right */
				head_1.record.ndata=length_2;
				strncat(strng,"a",1);
				if(real_time == 'y')strncat(strng,"t",1);
				strncat(strng,";",1);
				logger(strng,&head_1);
				maxamp (&head_1,result);
				break;
			case 's':
				result=t_sub(data_1,data_2,length_1);
				/* get output data length right */
				if(head_2.record.ndata > head_1.record.ndata)head_2.record.ndata=head_1.record.ndata;
				head_2.record.ndata-=int_diff;
				strncat(strng,"s",1);
				if(real_time == 'y')strncat(strng,"t",1);
				strncat(strng,";",1);
				logger(strng,&head_2);
				maxamp (&head_2,result);
				break;

		}

		first_record='n';


		/* write outputs and free array space */

		if(xdr_puthead(&head_1,&xdr_stdout) != 1) {
			fprintf(stderr, "%s: error writing header\n");
			exit(-4);
		}
		if(xdr_putdata(&head_1,result, &xdr_stdout) == -1) {
			fprintf(stderr, "%s: error writing data\n");
			exit(-4);
		}
		cfree((char *)result);
		cfree((char *)data_2);
		if(only_first == 'n')cfree((char *)data_1);
	}
	xdr_destroy(&xdr_stdin);
	xdr_destroy(&xdr_stdout);
	xdr_destroy(&xdr_filein);
}

/* routine to multiply the frequency components of two timeseries
 * routines take the fft output of two timeseries which were of the
 * same length
 *
 * Inputs:
 *	a,b=frequency components of the two timeseries
 *
 * Outputs:
 *	pointer to the resulting frequency components of length ndata
 *	Array space for the output array is created in this routine
 * 
 */
float *f_mult(a,b,ndata)

	float *a,*b;
	int ndata;
{
	float *result;
	int i;

	if((result=(float *)calloc((unsigned)(ndata+2),sizeof(float)))==NULL)
	{
		fprintf(stderr,"Error allocating space for frequency multiplication\n");
		exit(-2);
	}

	for(i=0;i<=ndata;i+=2)
	{
		result[i]=a[i]*b[i]-a[i+1]*b[i+1];
		result[i+1]=a[i]*b[i+1]+a[i+1]*b[i];
	}
	return(result);
}
/* routine to deconvolve two timeseries
 * routines take the fft output of two timeseries which were of the
 * same length
 *
 * Inputs:
 *	a,b=frequency components of the two timeseries
 *
 * Outputs:
 *	pointer to the resulting frequency components of length ndata
 *	Array space for the output array is created in this routine
 * 
 */
float *f_div(a,b,ndata)

	float *a,*b;
	int ndata;
{
	float *result,temp;
	int i;

	if((result=(float *)calloc((unsigned)(ndata+2),sizeof(float)))==NULL)
	{
		fprintf(stderr,"Error allocating space for frequency multiplication\n");
		exit(-2);
	}

	for(i=0;i<=ndata;i+=2)
	{
		result[i]=a[i]*b[i]+a[i+1]*b[i+1];
		result[i+1]=b[i]*a[i+1]-a[i]*b[i+1];
		temp=b[i]*b[i]+b[i+1]*b[i+1];
		if(temp == 0.0)  /* prevent division by zero */
		{
			result[i]=result[i+1]=0.0;
		}
		else
		{
			result[i]/=temp;
			result[i+1]/=temp;
		}
	}
	return(result);
}

/* routine to algebraicly add the values of two timeseries
 * routines assume the series are of the same length
 * and start at the same time
 *
 * Inputs:
 *	a,b=two timeseries to be added of length ndata
 *
 * Outputs:
 *	pointer to the resulting timeseries also of length ndata
 *	Array space for the output array is created in this routine
 *
 */
float *t_add(a,b,ndata)

	float *a,*b;
	int ndata;

{

	float *result,*array_end;

	if((result=(float *)calloc((unsigned)(ndata),sizeof(float))) == NULL)
	{
		fprintf(stderr,"Error allocating space for timeseries addition\n");
		exit(-2);
	}

	array_end=result+ndata;
	for(;result<array_end;++result,++a,++b)
	{
		*result=(*a)+(*b);
	}

	return(array_end-ndata);
}

/* routine two algebraically subtract the values of two timeseries
 * routines assume the series are of the same length
 * and start at the same time
 *
 * Inputs:
 *	a,b=two timeseries of length ndata to be subtracted (a-b)
 *
 * Outputs:
 *	pointer to the resulting timeseries (a-b) also of length ndata
 *	Array space for the output array is created in this routine
 *
 */
float *t_sub(a,b,ndata)

	float *a,*b;
	int ndata;

{

	float *result,*array_end;

	if((result=(float *)calloc((unsigned)(ndata),sizeof(float))) == NULL)
	{
		fprintf(stderr,"Error allocating space for timeseries addition\n");
		exit(-2);
	}

	array_end=result+ndata;
	for(;result<array_end;++result,++a,++b)
	{
		*result=(*a)-(*b);
	}

	return(array_end-ndata);
}

/* convolves two timeseries in the time domain
 *
 * Inputs:
 *	a,b=two timeseries to be convolved
 *	ndata_a,ndata_b=lengths of the timeseries
 *
 * Outputs:
 *	routine returns a pointer to an array ndata_a+ndata_b-1 points long
 *	containing the convolved trace.  Array space is created in this 
 *	routine for the output
 *
 */
float *t_fold(a,ndata_a,b,ndata_b)

	float *a,*b;
	int ndata_a,ndata_b;

{

	int i,j,k;
	float *result;

	if((result=(float *)calloc((unsigned)(ndata_a+ndata_b-1),sizeof(float))) == NULL)
	{
		fprintf(stderr,"Error allocating space for timeseries convolution\n");
		exit(-2);
	}

	for(i=0;i<ndata_a;++i)
	{
		for(j=0;j<ndata_b;++j)
		{
			k=i+j;
			result[k]=a[i]*b[j]+result[k];
		}
	}

	return(result);
}
/* routine to algebraicly multply the values of two timeseries
 * routines assume the series are of the same length
 * and start at the same time
 *
 * Inputs:
 *	a,b=two timeseries to be multiplied of length ndata
 *
 * Outputs:
 *	pointer to the resulting timeseries also of length ndata
 *	Array space for the output array is created in this routine
 *
 */
float *t_mult(a,b,ndata)
	float *a,*b;
	int ndata;
{
	float *result,*array_end;

	if((result=(float *)calloc((unsigned)(ndata),sizeof(float))) == NULL)
	{
		fprintf(stderr,"Error allocating space for timeseries multiplication\n");
		exit(-2);
	}

	array_end=result+ndata;
	for(;result<array_end;++result,++a,++b)
	{
		*result=(*a)*(*b);
	}

	return(array_end-ndata);
}
