/* This program detrends an ah format data file 
 *
 *				Error conditions;
 *					-1 = Error in command line input
 *					-2 = Error allocating array space
 *					-3 = Error reading data
 *					-4 = Wrong data type
 *					-5 = Error writing output data
 *
 *			Latest Revision; August 5, 1986
 *				By; Tom Boyd
 *
 *			Update to read and write xdr ahfiles; September 20, 1989
 *				By; Ken Howard
 *
 */
#include <stdio.h>
#include <rpc/rpc.h>
#include <math.h>
#include "ahhead.h"

char *progname;
main (argc,argv)
	int argc;
	char *argv[];
{
	ahhed head;
	XDR xdr_in, xdr_out;
	char *calloc();
	float x_sum,y_sum,xy_sum,x_sum2,x_bar,y_bar,intercept,slope;
	float *data;
	int count;
	void scale();
	progname=argv[0];
	if((out_is_tty() != 0)||(in_is_tty() != 0))
	{
		fprintf(stderr,"Usage: %s < stdin > stdout\n",progname);
		exit(-1);
	}

	xdrstdio_create(&xdr_in, stdin, XDR_DECODE);
	xdrstdio_create(&xdr_out, stdout, XDR_ENCODE);

	while(xdr_gethead(&head, &xdr_in) == 1)
	{

		/* check data type can currently only detrend floats */

		if(head.record.type != FLOAT)
		{
			fprintf(stderr,"Error in %s--Data type not float\n");
			exit(-4);
		}

		/* allocate array space */

		if((data=(float *)calloc((unsigned)(head.record.ndata),sizeof(float))) == NULL)
		{
			fprintf(stderr,"Error allocating space in %s\n",progname);
			exit(-2);
		}

		/* read data */

		if(xdr_getdata(&head,(char *)data, &xdr_in) <= 0)
		{
			fprintf(stderr,"Error reading data in %s\n",progname);
			exit(-3);
		}

		/* determine best fit line to the data */

		x_sum=y_sum=xy_sum=x_sum2=0.0;
		for(count=0;count<head.record.ndata;count++)
		{
			x_sum+=(count*head.record.delta);
			y_sum+=data[count];
			xy_sum+=(count*head.record.delta*data[count]);
			x_sum2+=(count*head.record.delta*count*head.record.delta);
		}

		x_bar=x_sum/head.record.ndata;
		y_bar=y_sum/head.record.ndata;

		slope=(xy_sum-x_sum*y_sum/head.record.ndata)/(x_sum2-x_sum*x_sum/head.record.ndata);
		intercept=y_bar-slope*x_bar;	
		/* detrend data */

		for(count=0;count<head.record.ndata;count++)
		{
			data[count]-=(intercept+slope*count*head.record.delta);
		}
		/* change appropriate header values */

		logger("detrend;",&head);

		/* write header and data */

		if(xdr_puthead(&head, &xdr_out) != 1) {
			fprintf(stderr,"Error writing header in %s\n",progname);
			exit(-5);
		}
		if(xdr_putdata(&head,(char *)data, &xdr_out) == -1) {
			fprintf(stderr,"Error writing data in %s\n",progname);
			exit(-5);
		}

		/* free array space */

		cfree((char *)data);
	}
	xdr_destroy(&xdr_in);
	xdr_destroy(&xdr_out);
}
