/* This program substract the tides from an ah-file
 *
 *				Error conditions;
 *					-1 = Error in command line input
 *					-2 = Error allocating array space
 *					-3 = Error reading data
 *
 *			Latest Revision; Sept. 30, 1990
 *				By; pl
 *
 */
#include <stdio.h>
#include <math.h>
#include "ahhead.h"
#include <rpc/rpc.h>

char *progname;
main (argc,argv)
	int argc;
	char *argv[];
{
	XDR xdr_in, xdr_out;
	ahhed head;
	char *calloc();
	char ifl1='y',iynme='y',iyntr='y',ifl4='n',ifl2='n',ihc='y';
	float f[50],fc[50],nsd,spc=1.,pour=0.;
	float *data,*data2,scale_fact,delta;
	int count,ndata,ifl3 =1 ,i,itrou=1;



        progname=argv[0];
        if(argc < 1)
        {
                fprintf(stderr,"Usage--%s [-H] [-d] [-t] [-l nsd f(i)] [-o (amp,phase,i) ] [-s spc] < ah_file > \n",progname);
                exit(-1);
        }
        for(count=1;count<argc;count++)
        {
                if((*argv[count]) == '-')
                {
                        switch (*(argv[count]+1))
                        {
				case 'f':
					itrou=0;
					break;
                                case 'd':
					iynme='n';
                                        break;
                                case 't':
					iyntr='n';
                                        break;
                                case 's':
                                        if(argc < count+2)
					{
						fprintf(stderr,"Error in command line to program %s: type %s -H or help\n",progname,progname);
						exit(-1);
					 	break;	
					}
					spc=atof(argv[count+1]);
                                        count+=1;
                                        break;
				case 'l':
					ihc='n';
					nsd=atoi(argv[count+1]);
					count+=1;
					if(argc< count + nsd)
					for(i=0;i<nsd;i++)
					{
						f[i]=atof(argv[count+1]);
						count+=1;
					}					
                                        break;
				case 'o':
					ifl4='y';
					nsd=atoi(argv[count+1]);
					count+=1;
					if(argc< count + 2*nsd)
						fprintf(stderr,"Error in command line to program %s: type %s -H or help\n",progname,progname);
					for(i=0;i<nsd;i++)
					{
						fc[2*i]=atof(argv[count+1]);
						f[2*i+1]=atof(argv[count+2]);
						count+=2;
					}
                                        break;
				case 'm':
					pour=atof(argv[count+1]);
					count+=1;
					break;
				case 'H':

					fprintf(stderr," %s",progname);         
   					fprintf(stderr," fits a sum of tidal harmonics (as many as allowed by the \n");
   					fprintf(stderr," record length), and a constant and trend.  the least-square \n");
   					fprintf(stderr," coefficients may then be used to fill gaps in the series, and \n");
   					fprintf(stderr," may be printed out as well (in the form of amplitude and phase, \n");
   					fprintf(stderr," referred to the start time).  if gap-filling is to be done, the \n");
   					fprintf(stderr," series must be real.  the fitted tide may be subtracted out \n");
   					fprintf(stderr," to leave a residual series. this is written to another file. in \n");
   					fprintf(stderr," computing the residual, data in gaps is included, though it is \n"); 
   					fprintf(stderr," not used in doing the fit. the removal of the constant and trend \n");
   					fprintf(stderr," from the residual is optional  \n");
    					fprintf(stderr," the tidal frequencies used are ordinarily chosen from a list in \n");
   					fprintf(stderr," the data statement, in which they are ranked according to \n");
   					fprintf(stderr," potential amplitude. frequencies chosen by the user may be input also. \n ");
                			fprintf(stderr,"Usage--%s [-H] [-d] [-t] [-l nsd f(i)] [-o (amp,phase,i) ] [-s spc] < ah_file > \n",progname);
					fprintf(stderr,"-d :the residual is not demeaned \n");
					fprintf(stderr,"-t :the residual is not detrended \n");
					fprintf(stderr,"-l nsd f(i) :the tidal lines are given in the following manner \n");
					fprintf(stderr,"              nsd is the number of lines, f(i) the frequencies in cpd \n");
					fprintf(stderr,"-o nsd amp(i) phase(i) :the ocean coreection is given in the following manner \n");
					fprintf(stderr,"                        nsd is the number of lines, \n amp(i) and phase(i) the amplitudes and phase \n");
					fprintf(stderr,"-s spc: spc is the minimum spacing between harmonics, usually 1\n");
                			exit(-1);
					break;

       				default:
                                        fprintf(stderr,"Error in command line to program %s: type %s -H for help\n",progname,progname);
                                        exit(-1);
                                        break;
                        }
                }
                else
                {
                        fprintf(stderr,"Error in command line to program %s: type %s -H for help\n",progname,progname);
                        exit(-1);
                        break;
                }
        }

/* Open XDR streams for stdio */
	xdrstdio_create(&xdr_in, stdin, XDR_DECODE);
	xdrstdio_create(&xdr_out, stdout, XDR_ENCODE);

	while(xdr_gethead(&head, &xdr_in) == 1)
	{
/* allocate array space */

		if((data=(float *)calloc((unsigned)(head.record.ndata*head.record.type),sizeof(float))) == NULL)
		{
			fprintf(stderr,"Error allocating space in %s\n",progname);
			exit(-2);
		}

/* allocate tmp-array space */

		if((data2=(float *)calloc((unsigned)(head.record.ndata*head.record.type),sizeof(float))) == NULL)
		{
			fprintf(stderr,"Error allocating space in %s\n",progname);
			exit(-2);
		}

/* read data */

		if(xdr_getdata(&head,(char *)data, &xdr_in) <= 0)
		{
			fprintf(stderr,"Error reading data in %s\n",progname);
			exit(-3);
		}

/* substract the tide from data */
		ndata=(int)head.record.ndata;
                delta=head.record.delta;
	
		fprintf(stderr,"go for the tide:\n");
	maree_(data,data2,&delta,&ndata,&ifl1,&ifl3,&iynme,&iyntr,&ifl4,&ifl2,&ihc,&spc,&nsd,f,fc,&pour,&itrou);
/* write header and data */

		maxamp(&head,data);
		if(xdr_puthead(&head, &xdr_out) != 1)
		{
			fprintf(stderr,"Error writing header in %s\n",progname);
			exit(-3);
		}
		if(xdr_putdata(&head,(char *)data, &xdr_out) < 0)
		{
			fprintf(stderr,"Error writing data in %s\n",progname);
			exit(-3);
		}

/* free array space */

		cfree((char *)data);
		cfree((char *)data2);
	}

xdr_destroy(&xdr_in);
xdr_destroy(&xdr_out);
}
