/*	Routine to modify header information in an ah format file
		Currently one can only modify event information

			Written Tom Boyd
				Last Modification Nov. 1, 1986
			Modified by Art Lerner-Lam Sept 24, 1986
			Modified by ALL & Feb 1987 to read poles and zeroes
			Modified by P. Lognonne-ipgp  March, 1990 to insert source tensor
*/
#include <stdio.h>
#include <math.h>
#include <ctype.h>
#include <strings.h>
#include <rpc/rpc.h>
#include "ahhead.h"

char *progname;
main (argc,argv)
	int argc;
	char *argv[];
{
	XDR xdr_out, xdr_in1;
	ahhed head;
	char *calloc(),command[80],buf[512],test[10];
	float *data,scale_fact,lat,lon,depth,sec;
	float a0,ds,temp;
        float M11,M22,M33,M12,M23,M13,tau,dtc,phi,delta,landa,Mag;
	float pi=3.14159265358979;
        float L1,L2,AZI1;
	float real,imag;
	short hr,min,yr,mn,day;
	int num_changes,count;
	int num_poles,num_zeroes;
	int i,length,ix=0;
	FILE *fopen(),*FILE_IN,*STA,*popen();
	char *chan,*type,*st_type,*end,*index();
	char process[15];
	progname=argv[0];
	if(argc < 2)
	{
		fprintf(stderr,"Usage--%s [-H] [-e event_parameters] [-mM event_mechanism ] [-d Doppler source ] [-s station_parameters] [-l fact] [-r] [-v] [-w] [-c] [-t] [-a] [-u] -i ah_file > \n",progname);
		exit(-1);
	}
	num_changes=0;
	for(count=1;count<argc;count++)
	{
		if((*argv[count]) == '-')
		{
			switch (*(argv[count]+1))
			{
				case 'x':
					ix=1;
					break;
				case 'd':
					if(argc < count+4)
					{
						fprintf(stderr,"Error in command line to program %s: type %s -H for help\n",progname,progname);
						exit(-1);
						break;
					}
					L1=atof(argv[count+1]);
					AZI1=atof(argv[count+2]);
					L2=atof(argv[count+3]);
					count+=3;
					process[num_changes]='d';
					num_changes++;
					break;
				case 'M':
					if(argc < count+9)
					{
						fprintf(stderr,"Error in command line to program %s: type %s -H for help\n",progname,progname);
						exit(-1);
						break;
					}
					M33=atof(argv[count+1]);
					M11=atof(argv[count+2]);
					M22=atof(argv[count+3]);
					M13=atof(argv[count+4]);
					M23=atof(argv[count+5]);
					M12=atof(argv[count+6]);
					tau=atof(argv[count+7]);
					dtc=atof(argv[count+8]);
					count+=8;
					process[num_changes]='M';
					num_changes++;
					break;
				case 'm':
					if(argc < count+7)
					{
						fprintf(stderr,"Error in command line to program %s: type %s -H for help\n",progname,progname);
						exit(-1);
						break;
					}
					phi=atof(argv[count+1]);
					delta=atof(argv[count+2]);
					landa=atof(argv[count+3]);
                                        phi=phi*pi/180.;
					delta=delta*pi/180.;
					landa=landa*pi/180;
					Mag=atof(argv[count+4]);
					tau=atof(argv[count+5]);
					dtc=atof(argv[count+6]);
					count+=6;
					process[num_changes]='m';
					num_changes++;
					break;
				case 'e':
					if(argc < count+10)
					{
						fprintf(stderr,"Error in command line to program %s: type %s -H for help\n",progname,progname);
						exit(-1);
						break;
					}
					lat=atof(argv[count+1]);
					lon=atof(argv[count+2]);
					depth=atof(argv[count+3]);
					yr=(short)atoi(argv[count+4]);
					if(yr < 100)yr+=1900;
					mn=(short)atoi(argv[count+5]);
					day=(short)atoi(argv[count+6]);
					hr=(short)atoi(argv[count+7]);
					min=(short)atoi(argv[count+8]);
					sec=atof(argv[count+9]);
					count+=9;
					process[num_changes]='e';
					num_changes++;
					break;
				case 'l':
					process[num_changes]='l';
					if((isdigit((*argv[count+1])) == 0) && 
						(isdigit((*(argv[count+1]+1))) == 0)) /* next arg not a number */
					{
						fprintf(stderr,"Error in command line to program %s: type %s -H for help\n",progname,progname);
						exit(-1);
						break;
					}

					scale_fact=atof(argv[count+1]);
					count++;
					num_changes++;
					break;
				case 'u':
					process[num_changes]='u';
					num_changes++;
					break;
				case 't':
					process[num_changes]='t';
					num_changes++;
					break;
				case 'a':
					process[num_changes]='a';
					num_changes++;
					break;
				case 's':
					if(argc < count+3)
					{
						fprintf(stderr,"Error in command line to program %s: type %s -H for help\n",progname,progname);
						exit(-1);
						break;
					}
					chan=argv[count+1];
					type=argv[count+2];
					count+=2;
					process[num_changes]='s';
					num_changes++;
					break;
					
				case 'r':
					fprintf(stderr,"Enter num_poles and num_zeroes interactively.\n");
					process[num_changes]='r';
					num_changes++;
					break;
					
				case 'v':
					fprintf(stderr,"Enter DS (gain) interactively.\n");
					process[num_changes]='v';
					num_changes++;
					break;

				case 'w':
					fprintf(stderr,"Enter A0 (normalization) interactively.\n");
					process[num_changes]='w';
					num_changes++;
					break;

				case 'c':
					process[num_changes]='c';
					num_changes++;
					break;
					
				case 'i':
					if((FILE_IN=fopen(argv[count+1],"r+")) == NULL)
					{
						fprintf(stderr,"Error in %s: trying to open %s\n",progname,argv[count+1]);
						exit(-2);
					}
					xdrstdio_create(&xdr_in1, FILE_IN, XDR_DECODE);
					count++;
					break;

				case 'H':
					fprintf(stderr,"Usage--%s [-H] [-e event_parameters] [-s station_parameters] [-l fact] [-r] [-v] [-w] [-c] [-t] [-a] [-u] -i ah_file > \n",progname);
					fprintf(stderr,"\n-e = change event information");
					fprintf(stderr,"\n     9 parameters entered in the following order");
					fprintf(stderr,"\n        lat,lon,depth = latitude, longitude, and depth in");
					fprintf(stderr,"\n                   decimal degrees and kms");
					fprintf(stderr,"\n        yr,mn,day,hr,min = origin time of event (int)");
					fprintf(stderr,"\n        sec = origin time of event (float)");
					fprintf(stderr,"\n-M = change event mechanism information (CMT convention)");
					fprintf(stderr,"\n     8 parameters entered in the following order");
					fprintf(stderr,"\n     M33, M11, M22, M13, M23, M12 in dyne*cm*e+27");
					fprintf(stderr,"\n     tau dtc (half duration time and centroid time shift in s)");
					fprintf(stderr,"\n     Convention: M33, M11, M22, M13, M23, M12 (Phinney & Burridge )");
					fprintf(stderr,"\n     Convention:  f1,  f2,  f3,  f4,  f5,  f6 (Woodhouse & Masters)");
					fprintf(stderr,"\n-d = change event doppler   information ");
					fprintf(stderr,"\n     3 parameters entered in the following order");
					fprintf(stderr,"\n     L1, AZI1 great length fault (km) and azimuth (degree)");
					fprintf(stderr,"\n     L2       small length fault (km)");
					fprintf(stderr,"\n-m = change event mechanism information (sdr convention)");
					fprintf(stderr,"\n     6 parameters entered in the following order");
					fprintf(stderr,"\n     strike dip rake  (shear fault angles in degree Aki&Richards page 117)");
					fprintf(stderr,"\n     M                (moment tensor amplitude in dyne*cm*e+27)");
					fprintf(stderr,"\n     tau dtc (half duration time and centroid time shift in s)");
					fprintf(stderr,"\n-s = change station information");
					fprintf(stderr,"\n     2 parameters entered in the follow order");
					fprintf(stderr,"\n         chan = channel lpz,spn etc.");
					fprintf(stderr,"\n         type = instrument type  wwssn, hglp etc.");
					fprintf(stderr,"\n-a = remove absolute timing of each trace");
					fprintf(stderr,"\n-l = multiply station longitudes by fact");
					fprintf(stderr,"\n-u = calculate and insert maximum trace amp in head");
					fprintf(stderr,"\n-r = add number_poles and number_zeroes to response array.");
					fprintf(stderr,"\n-v = replace DS (gain) with input value.");
					fprintf(stderr,"\n-w = replace A0 (normalization) with input value.");
					fprintf(stderr,"        NOTE--modes r,v, and w are interactive");
					fprintf(stderr,"\n-c = interchange DS and A0 in each header");
					fprintf(stderr,"\n-t = include station location information");
					fprintf(stderr,"	NOTE--for this to work,CSS routine 'sta' must be in bin");
					fprintf(stderr,"\n-i = input file is 'ah_file'\n");
					exit(-1);
					break;

				default:
					fprintf(stderr,"Error in command line to program %s: type %s -H for help\n",progname,progname);
					exit(-1);
					break;
			}
		}
		else
		{
			fprintf(stderr,"Error in command line to program %s: type %s -H for help\n",progname,progname);
			exit(-1);
			break;
		}
	}


	/* make sure FILE_IN points to a file */

	if(FILE_IN == NULL)
	{
		fprintf(stderr,"Error in command line to program %s: type %s -H for help\n",progname,progname);
		exit(-1);
	}

/* Open XDR streams for stdio */
	xdrstdio_create(&xdr_out, stdout, XDR_ENCODE);


/*
open ah_file input on file_in
*/
	while(xdr_gethead(&head, &xdr_in1) == 1)
	{

		/* allocate array space */

		if((data=(float *)calloc((unsigned)(head.record.ndata),sizeof(float))) == NULL)
		{
			fprintf(stderr,"Error allocating space in %s\n",progname);
			exit(-2);
		}

		/* read data */

		if( ix == 0) {
		if(xdr_getdata(&head,(char *)data, &xdr_in1) <= 0)
		{
			fprintf(stderr,"Error reading data in %s\n",progname);
			exit(-3);
		}
		}

		/* change appropriate header values */

		for(count=0;count<num_changes;count++)
		{
			switch(process[count])
			{
				case 'd':
					head.extra[12]=L1;
					head.extra[13]=AZI1;
					head.extra[14]=L2;
					break;
				case 'M':
					head.extra[0]=M11*1.e27;
					head.extra[1]=M22*1.e27;
					head.extra[2]=M33*1.e27;
					head.extra[3]=M12*1.e27;
					head.extra[4]=M13*1.e27;
					head.extra[5]=M23*1.e27;
					head.extra[6]=dtc;
					head.extra[7]=tau;
					break;
				case 'm':
					M11=-Mag*(sin(delta)*cos(landa)*sin(2.*phi)+sin(2.*delta)*sin(landa)*sin(phi)*sin(phi));
                                        M12=-Mag*(sin(delta)*cos(landa)*cos(2.*phi)+.5*sin(2.*delta)*sin(landa)*sin(2.*phi));
                                        M13=-Mag*(cos(delta)*cos(landa)*cos(phi)+cos(2.*delta)*sin(landa)*sin(phi));
              				M22=Mag*(sin(delta)*cos(landa)*sin(2.*phi)-sin(2.*delta)*sin(landa)*cos(phi)*cos(phi));
              				M23=Mag*(cos(delta)*cos(landa)*sin(phi)-cos(2.*delta)*sin(landa)*cos(phi));
              				M33=Mag*sin(2.*delta)*sin(landa);
					head.extra[0]=M11*1.e27;
					head.extra[1]=M22*1.e27;
					head.extra[2]=M33*1.e27;
					head.extra[3]=M12*1.e27;
					head.extra[4]=M13*1.e27;
					head.extra[5]=M23*1.e27;
					head.extra[6]=dtc;
					head.extra[7]=tau;
					head.extra[8]=phi*180./pi;
					head.extra[9]=delta*180./pi;
					head.extra[10]=landa*180/pi;
					head.extra[11]=Mag*1.e27;
					break;
				case 'e':
					head.event.lat=lat;
					head.event.lon=lon;
					head.event.dep=depth;
					head.event.ot.yr=yr;
					head.event.ot.mo=mn;
					head.event.ot.day=day;
					head.event.ot.hr=hr;
					head.event.ot.mn=min;
					head.event.ot.sec=sec;
					break;
				case 'l':
					head.station.slon*=scale_fact;
					break;
				case 'c':
					temp=head.station.DS;
					head.station.DS=head.station.A0;
					head.station.A0=temp;
					break;
				case 'a':
					head.record.abstime.yr=0;
					head.record.abstime.mo=0;
					head.record.abstime.day=0;
					head.record.abstime.hr=0;
					head.record.abstime.mn=0;
					head.record.abstime.sec=0.0;
					break;
				case 't':
						/* open CSS program */

					strcpy(command,"/usr/chaos/bin/sta ");
					strncat(command,head.station.code,6);
					STA=popen(command,"r");

						/* read output from CSS program */

					fgets(buf,512,STA);
					strncpy(test,buf,4);
					if(strcmp(test,"sta:") == 0) /* was station found */
					{
						fprintf(stderr,"Station code %s not found--Continuing\n",head.station.code);
						head.station.slat=head.station.slon=0.0;
						head.station.elev=0.0;
					}
					else
					{
						sscanf(buf,"%*s %f %f %f",&head.station.slat,&head.station.slon,&head.station.elev);

						/* get instrument type */

						st_type=index(buf,'(');
						if(st_type != NULL) /* is instrument type given */
						{
							st_type++;
							end=index(buf,')');
							length=end-st_type;
							if(length > 5)length = 5;
							strncpy(head.station.stype,st_type,length);
						}
					}

						/* close sta */
		
					pclose(STA);
					break;
				case 's':
					strcpy(head.station.chan,chan);
					strcpy(head.station.stype,type);
					break;
				case 'u':
					if( ix == 0) maxamp(&head,data);
					break;
				case 'r':
					fprintf(stderr,"Station: %s, channel: %s\n",head.station.code,head.station.chan);
					fprintf(stderr,"Enter num_poles and num_zeroes: ");
					scanf("%d %d",&num_poles,&num_zeroes);
					for (i=1; i<=NOCALPTS-1; i++)
					{
						head.station.cal[i].pole.r = 0.;
						head.station.cal[i].pole.i = 0.;
						head.station.cal[i].zero.r = 0.;
						head.station.cal[i].zero.i = 0.;
					}
					for (i=1; i<=num_poles; i++)
					{
						fprintf(stderr,"Enter pole.real and pole.imag: ");
						scanf("%f %f",&real,&imag);
						head.station.cal[i].pole.r = real;
						head.station.cal[i].pole.i = imag;
					}
					for (i=1; i<=num_zeroes; i++)
					{
						fprintf(stderr,"Enter zero.real and zero.imag: ");
						scanf("%f %f",&real,&imag);
						head.station.cal[i].zero.r = real;
						head.station.cal[i].zero.i = imag;
					}
					head.station.cal[0].pole.r = num_poles;
					head.station.cal[0].zero.r = num_zeroes;
					head.station.cal[0].pole.i = 0.;
					head.station.cal[0].zero.i = 0.;
					break;
				case 'v':
					fprintf(stderr,"Station: %s, channel: %s\n",head.station.code,head.station.chan);
					fprintf(stderr,"Enter DS: ");
					scanf("%f",&ds);
					head.station.DS = ds;
					break;
				case 'w':
					fprintf(stderr,"Station: %s, channel: %s\n",head.station.code,head.station.chan);
					fprintf(stderr,"Enter A0: ");
					scanf("%f",&a0);
					head.station.A0 = a0;
					break;
			}
		}

		logger("modhead;",&head);


/* write header and data */

		if(xdr_puthead(&head, &xdr_out) != 1)
		{
			fprintf(stderr,"Error writing header in %s\n",progname);
			exit(-3);
		}
		if(ix == 0) {
		if(xdr_putdata(&head,(char *)data, &xdr_out) < 0)
		{
			fprintf(stderr,"Error writing data in %s\n",progname);
			exit(-3);
		}
		}

		/* free array space */

		cfree((char *)data);
	}

xdr_destroy(&xdr_in1);
xdr_destroy(&xdr_out);
}
