/* Program to high-pass and low-pass timeseries data using 1,2, or 3 pole
 * butterworth filters or cosine tapers.
 *
 *			Latest Revision November 3, 1987;
 *				by; Tom Boyd
 *
 */

#include <stdio.h>
#include <math.h>
#include "ahhead.h"
#include <rpc/rpc.h>

char *progname;
main (argc,argv)
int argc;
char *argv[];
{
	XDR xdr_in, xdr_out;
	ahhed head;
	double *response,maxamp;
	double inst_resp(),temp1;
	float three_db_point_high,three_db_point_low,*data;
	float freq,freq_inc,nyquist,nf,freq_beg_l,freq_end_l,freq_end_h,freq_beg_h;
	float temp,coef_real,coef_imag,omega,cut_omega,MHZ=.001;
	int order_high=0 ,order_low=0 ,i,ndata,intg=0;
	char high='n',low='n',inst='n';
	char backward='n';
	static char strng[15]={'f','i','l','t','e','r','-','\0'};


	progname=argv[0];
	if((argc<2)||(out_is_tty()!=0)||(in_is_tty()!=0))
	{
		fprintf(stderr,"Usage: %s -[Help] -hl  3db order -SL freq_beg freq_end -[ot] < stdin > stdout\n\n",progname);
		if(argc == 2)
		{
			if(*(argv[1]+1) == 'H')
			{
				fprintf(stderr,"-h = high-pass filter with the following parameters\n");
				fprintf(stderr,"-l = low-pass filter  with the following parameters\n");
				fprintf(stderr,"-o = filter time series in forward direction only (default)\n");
				fprintf(stderr,"-t = filter time series in both directions \n");
				fprintf(stderr,"3db_point = frequency point at which response is to be decreased by 3 db\n");
				fprintf(stderr," order = 1,2, or 3  order of butterworth polynomial\n");
				fprintf(stderr,"-S = high-pass cosine filter with the following parameters(lp & hp) \n");
				fprintf(stderr,"-L = low-pass cosine filter  with the following parameters\n");
				fprintf(stderr,"-B = band-pass cosine filter  with the following parameters\n");
				fprintf(stderr,"freq_beg = frequency point at which taper begin\n");
				fprintf(stderr,"freq_end = frequency point at which taper begin\n");
				fprintf(stderr,"-n natural window f1,f2 \n");
				fprintf(stderr,"-i derivation or integration by n f1,f2 \n");
				fprintf(stderr,"-r remove the instrument response \n");
				fprintf(stderr," all frequency n mHz\n");

			}
		}
		exit (-1);
	}
	for (i=1;i<argc;i++)
	{
		if(*(argv[i]) == '-')
		{
			switch (*(argv[i]+1))
				{
					case 'h':
						high='y';
						three_db_point_high=atof(argv[i+1])*MHZ;
						order_high=atoi(argv[i+2]);
						i+=2;
						break;
					case 'l':
						low='y';
						three_db_point_low=atof(argv[i+1])*MHZ;
						order_low=atoi(argv[i+2]);
						i+=2;
						break;
					case 'S':
						high='y';
						order_high=0;
						freq_beg_h=atof(argv[i+1])*MHZ;
						freq_end_h=atof(argv[i+2])*MHZ;
						i+=2;
						break;
					case 'L':
						low='y';
						order_low=0;
						freq_beg_l=atof(argv[i+1])*MHZ;
						freq_end_l=atof(argv[i+2])*MHZ;
						i+=2;
						break;
					case 'B':
						low='y';
						high='y';
						order_low=0;
						freq_beg_l=atof(argv[i+1])*MHZ;
						freq_end_l=atof(argv[i+2])*MHZ;
						freq_beg_h=atof(argv[i+3])*MHZ;
						freq_end_h=atof(argv[i+4])*MHZ;
						i+=4;
						break;
					case 'n':
						low='y';
						high='y';
						freq_beg_h=atof(argv[i+1])*MHZ;
						freq_beg_l=atof(argv[i+2])*MHZ;
						freq_end_l=freq_beg_l;
						freq_end_h=freq_beg_h;
						i+=2;
						break;
					case 'i':
						intg=atoi(argv[i+1]);
						i+=1;
						break;
					case 'o':
						backward='n';
						break;
					case 't':
						backward='y';
						break;
					case 'r':
						inst='y';
						break;
					default:
						fprintf(stderr,"Error in command line input to program %s: type '%s -H' for help\n",progname,progname);
						exit(-1);
				}
		}
		else
		{
			fprintf(stderr,"Error in command line input to programe %s: type '%s -H' for help\n",progname,progname);
		}
	}

/* Open XDR streams for stdio */
	xdrstdio_create(&xdr_in, stdin, XDR_DECODE);
	xdrstdio_create(&xdr_out, stdout, XDR_ENCODE);


	while(xdr_gethead(&head, &xdr_in) == 1)
	{
			/* determine power of two greater than data length */

		for(i=1;(int)pow((double)2,(double)i) < head.record.ndata;++i);
		ndata=(int)pow((double)2,(double)(i+1));

			/* allocate space for data */
	
		if((data=(float *)calloc((unsigned)(ndata+2),size(&head))) == NULL)
		{
			fprintf(stderr,"Error allocating space in %s\n",progname);
			exit(-2);
		}
		if((response=(double *)calloc((unsigned)(ndata+2),sizeof(double))) == NULL)
		{
		        fprintf(stderr,"Error allocating space in %s\n",progname);
		        exit(-2);
		}
		
			/* get data */

		if(xdr_getdata(&head,data, &xdr_in) <= 0)
		{
			fprintf(stderr,"Error reading data in %s\n",progname);
			exit(-3);
		}

			/* fft data */

		cfftr(data,ndata);

		nyquist=1.0/(2.0*head.record.delta);
		nf=(int)(ndata/2.0+1.0);
		freq_inc=nyquist/(nf-1.0);

			/* filter data in forward direction */

		if(high == 'y')  /* high pass */
		{
			freq=0.0;
			cut_omega=three_db_point_high/nyquist*3.1415926*2;
			for(i=0;i<=ndata;i+=2)
			{
				omega=freq/nyquist*3.1415926*2;
				if(order_high == 0)costap(freq,&coef_real,&coef_imag,freq_beg_h,freq_end_h,'h');
				if(order_high == 1)but1(omega,&coef_real,&coef_imag,cut_omega,'h');
				if(order_high == 2)but2(omega,&coef_real,&coef_imag,cut_omega,'h');
				if(order_high == 3)but3(omega,&coef_real,&coef_imag,cut_omega,'h');

				temp=data[i]*coef_real-data[i+1]*coef_imag;
				data[i+1]=data[i]*coef_imag+data[i+1]*coef_real;
				data[i]=temp;	
				freq+=freq_inc;
			}
		}

		if(low == 'y')  /* low pass */
		{
			freq=0.0;
			cut_omega=three_db_point_low/nyquist*3.1415926*2;
			for(i=0;i<=ndata;i+=2)
			{
				omega=freq/nyquist*3.1415926*2;
				if(order_low == 0) costap(freq,&coef_real,&coef_imag,freq_beg_l,freq_end_l,'l');
				if(order_low == 1)but1(omega,&coef_real,&coef_imag,cut_omega,'l');
				if(order_low == 2)but2(omega,&coef_real,&coef_imag,cut_omega,'l');
				if(order_low == 3)but3(omega,&coef_real,&coef_imag,cut_omega,'l'); 

				temp=data[i]*coef_real-data[i+1]*coef_imag;
				data[i+1]=data[i]*coef_imag+data[i+1]*coef_real;
				data[i]=temp;
				freq+=freq_inc;
			}

		}
		if(intg != 0 ) /* derivation or integration */
		{
			freq=0.0;
			for(i=0;i<=ndata;i+=2)
			{
				omega=freq/nyquist*3.1415926*2;
				integ(intg,omega,&coef_real,&coef_imag);
				temp=data[i]*coef_real-data[i+1]*coef_imag;
				data[i+1]=data[i]*coef_imag+data[i+1]*coef_real;
				data[i]=temp;
				freq+=freq_inc;
			}

		}

		if(inst == 'y')
		{
		/* calculate instrument response and remove */

			maxamp=inst_resp(&head,(d_complex *)response);


			/*  divide out instr */


			for(i=0,freq=0.0;i<=ndata;i+=2,freq+=freq_inc)
			{

				temp1=(double)data[i]*response[i]+(double)data[i+1]*response[i+1];
				data[i+1]=(float)(response[i]*(double)data[i+1]-(double)data[i]*response[i+1]);
				data[i]=(float)temp1;
				temp1=response[i]*response[i]+response[i+1]*response[i+1];
				if(temp1 == 0.0) /* prevent division by zero */
				{
					data[i]=data[i+1]=0.0;
				} else {
					data[i]=(float)((double)data[i]/temp1);
					data[i+1]=(float)((double)data[i+1]/temp1);
				}
			}
		}


			/* make backward pass on data if requested to make filter zero phase */

		if(backward == 'y')
		{

			/* take complex conjugate of data */

			for(i=0;i<=ndata;i+=2)data[i+1]*=(-1.0);

			/* filter data */

			if(high == 'y')  /* high pass */
			{
				freq=0.0;
				cut_omega=three_db_point_high/nyquist*3.1415926*2;
				for(i=0;i<=ndata;i+=2)
				{
					omega=freq/nyquist*3.1415926*2;
					if(order_high == 0)costap(freq,&coef_real,&coef_imag,freq_beg_h,freq_end_h,'h');
					if(order_high == 1)but1(omega,&coef_real,&coef_imag,cut_omega,'h');
					if(order_high == 2)but2(omega,&coef_real,&coef_imag,cut_omega,'h');
					if(order_high == 3)but3(omega,&coef_real,&coef_imag,cut_omega,'h');

					temp=data[i]*coef_real-data[i+1]*coef_imag;
					data[i+1]=data[i]*coef_imag+data[i+1]*coef_real;
					data[i]=temp;
					freq+=freq_inc;
				}
			}

			if(low == 'y')  /* low pass */
			{
				freq=0.0;
				cut_omega=three_db_point_low/nyquist*3.1415926*2;
				for(i=0;i<=ndata;i+=2)
				{
					omega=freq/nyquist*3.1415926*2;
					if(order_low == 0)costap(freq,&coef_real,&coef_imag,freq_beg_l,freq_end_l,'l');
					if(order_low == 1)but1(omega,&coef_real,&coef_imag,cut_omega,'l');
					if(order_low == 2)but2(omega,&coef_real,&coef_imag,cut_omega,'l');
					if(order_low == 3)but3(omega,&coef_real,&coef_imag,cut_omega,'l');

					temp=data[i]*coef_real-data[i+1]*coef_imag;
					data[i+1]=data[i]*coef_imag+data[i+1]*coef_real;
					data[i]=temp;
					freq+=freq_inc;
				}
			}

			/* take complex conjugate of data */

			for(i=0;i<=ndata;i+=2)data[i+1]*=(-1.0);

		}

			/* take inverse fft */

		cfftri(data,ndata);

			/* get amplitudes right */

		for(i=0;i<ndata;i++)data[i]*=(2.0/ndata);

			/* modify header and write data */

		if(high == 'y' && order_high == 0)strncat(strng,"S",1);
		if(high == 'y' && order_high != 0)strncat(strng,"h",1);
		if(low == 'y' && order_low == 0 )strncat(strng,"L",1);
		if(low == 'y' && order_low != 0 )strncat(strng,"l",1);
		if(backward == 'n')strncat(strng,"f",1);
		if(backward == 'y')strncat(strng,"b",1);
		strncat(strng,";",1);
		logger(strng,&head);

/* write header and data */

		if(xdr_puthead(&head, &xdr_out) != 1)
		{
			fprintf(stderr,"Error writing header in %s\n",progname);
			exit(-3);
		}
		if(xdr_putdata(&head,(char *)data, &xdr_out) < 0)
		{
			fprintf(stderr,"Error writing data in %s\n",progname);
			exit(-3);
		}

			/* release array space */

		cfree((char *)data);
	}

xdr_destroy(&xdr_in);
xdr_destroy(&xdr_out);
}
/*	Subroutine inst_resp takes pole and zero information from an
	ah format file and calulates the real and imaginary instrument
	response.  Procedure is as given in Kanaswich page 271.

	Input parameters:
		head_pt -> pointer to an ah format header
		data_length -> length of time series for which instrument
			       response is needed
		dt	-> sample interval in seconds

	Output paramters:
		response -> pointer to a complex array containing the
			    instrument response. Response starts in postion 
			    one, and space must be calloced in the mainline
		function -> returns the maximum amplitude of the response

*/

double inst_resp(head_pt,response)

ahhed *head_pt;
d_complex *response;

{

float freq_inc,freq;
float nyquist;
int nf,num_poles,num_zeros,i,j,anump;
double save,amp,maxamp=(0.0e-304);
d_complex omega,denum,num,temp,gain;

/* get number of poles and zeros from header and calculate frequency interval */

	num_poles=(int)(head_pt->station.cal[0].pole.r);
	num_zeros=(int)(head_pt->station.cal[0].zero.r);

/* check to see if there is calibration information */

	gain.i=0.0;
	gain.r=(double)(head_pt->station.A0);     /* A0 */
	gain.r*=(double)(head_pt->station.DS);   /* DS */

	if((num_poles == 0) && (num_zeros == 0) && (gain.r == 0.) )
	{
		fprintf(stderr,"No calibration information present\n");
		exit(-9);
	}

/*	get nearest power of 2 thats at least twice the data length */

	for(i=1;((int)pow((double)2,(double)i))<(head_pt->record.ndata);++i);
	anump=(int)pow((double)2,(double)(i+1));

/*	calculate nyquist, number of frequency points, and frequency interval */

	nyquist=1.0/(2.0*(head_pt->record.delta));
	nf=(int)(anump/(2.0)+1);
	freq_inc=nyquist/(float)(nf-1.0);

/* loop through frequencies and calculate response */

	for(freq=0.0,j=0;j<nf;freq+=freq_inc,++j)
	{
		omega.i=freq*2.0*3.1415926;	
		omega.r=0.0;
		denum.r=denum.i=num.r=num.i=1.0;

		for(i=1;i<=num_poles;++i)
		{
			/* denum=denum*(omega-pole[i]) */
			temp.r=omega.r-(double)head_pt->station.cal[i].pole.r;
			temp.i=omega.i-(double)head_pt->station.cal[i].pole.i;
			save=denum.r*temp.r-denum.i*temp.i;
			temp.i=denum.r*temp.i+denum.i*temp.r;
			temp.r=save;
			denum.r=temp.r;
			denum.i=temp.i;
		}
		for(i=1;i<=num_zeros;++i)
		{
			/* num=num*(omega-zero[i]) */
			temp.r=omega.r-(double)head_pt->station.cal[i].zero.r;
			temp.i=omega.i-(double)head_pt->station.cal[i].zero.i;
			save=num.r*temp.r-num.i*temp.i;
			temp.i=num.r*temp.i+num.i*temp.r;
			temp.r=save;
			num.r=temp.r;
			num.i=temp.i;
		}
		/* gain*num */
		save=gain.r*num.r;
		num.i=gain.r*num.i;
		num.r=save;

		/* num/denum */
		temp.r=num.r*denum.r+num.i*denum.i;
		temp.i=num.i*denum.r-num.r*denum.i;
		save=denum.r*denum.r+denum.i*denum.i;
		temp.r/=save;
		temp.i/=save;

		/* find maximum amplitude */
		amp=temp.r*temp.r+temp.i*temp.i;
		if(amp > maxamp)maxamp=amp;
		response[j].r=temp.r;
		response[j].i=temp.i;
	}
	maxamp=sqrt(maxamp);
	return(maxamp);
}	
