/* This program takes either three component data or the two horizontals
 *  and rotates them to either vertical radial and tangential or x y z
 *	Convention as of Aki and Richards 
 *
 *			Last revision; December 1, 1987  (polarity on radial component backwards)
 *				by; Tom Boyd
 *
 *			Updated to Read and Write xdr ah files; September 22, 1989
 *				by; Ken Howard
 *			updated by Eleonore Stutzmann (fev94) to take in account azimut of the components
 *
 */	
#include <stdio.h>
#include <rpc/rpc.h>
#include <ctype.h>
#include <math.h>
#include "ahhead.h"

#define TO_VRT 0
#define TO_XYZ 1
#define DEG_PER_RAD 57.2957804904
#define MIN(a,b)	(( (a) < (b) ) ? (a) : (b) )

char *progname;
main(argc,argv)
int argc;
char *argv[];
{

	ahhed head_pz,head_pn,head_pe;
	float dist,azi,bazi,temp,cosphi,sinphi;
	float cmpaz_n,cmpin_n,cmpaz_e,cmpin_e,phi_n, phi_e;
	float cosphi_n,sinphi_n,cosphi_e,sinphi_e,e;
	float *data_pz,*data_pn,*data_pe,n_scale,e_scale;
	char calculate_bazi='y',outfile[100],prefix[100],got_vert='n',test[6],*log_pt;
	int ndata,i,count,str_out,log_length,operation=0;
	int flag;
	FILE *fopen(),*FILE_PZ,*FILE_PN,*FILE_PE,*OUT_PV,*OUT_PR,*OUT_PT;
	XDR xdr_in_pz, xdr_in_pn, xdr_in_pe;
	XDR xdr_out_pv, xdr_out_pr, xdr_out_pt;

	progname=argv[0];
	if(argc<4)
	{
		fprintf(stderr,"Usage: %s -[Help] -rs -[z vert_file] -n ns_file -e ew_file -[b back_azi] -o out_file \n\n",progname);
		if(argc >= 2)
		{
			if(*(argv[1]+1) == 'H')
			{
				fprintf(stderr,"-s = rotate from xyz to vert rad tang\n");
				fprintf(stderr,"-r = rotate from vert rad tang to xyz\n");
				fprintf(stderr,"-z = file containing vertical components\n");
				fprintf(stderr,"-n = file containing north south or radial components\n");
				fprintf(stderr,"-e = file containing east west or tangental components\n");
				fprintf(stderr,"-b = backazimuth is included in command line\n");
				fprintf(stderr,"-o = output files will have the prefix 'out_file'\n");
				fprintf(stderr,"	NOTE--absolute times are NOT checked!!!!\n");
			}
		}
		exit(-1);
	}

	for(i=1;i<argc;i++)
	{
		if(*(argv[i]) == '-')
		{
			switch(*(argv[i]+1))
			{
				case 's':
				{
					operation=TO_VRT;
					break;
				}
				case 'r':
				{
					operation=TO_XYZ;
					break;
				}
				case 'b':
				{
					calculate_bazi='n';
					bazi=atof(argv[i+1]);
					i++;
					break;
				}
				case 'z':
				{
					got_vert='y';
					if((FILE_PZ=fopen(argv[i+1],"r+")) == NULL)
					{
						fprintf(stderr,"Error in %s: trying to open %s\n",progname,argv[i+1]);
						exit(-1);
					}
					i++;
					xdrstdio_create(&xdr_in_pz, FILE_PZ, XDR_DECODE);
					break;
				}
				case 'n':
				{
					if((FILE_PN=fopen(argv[i+1],"r+")) == NULL)
					{
						fprintf(stderr,"Error in %s: trying to open %s\n",progname,argv[i+1]);
						exit(-1);
					}
					i++;
					xdrstdio_create(&xdr_in_pn, FILE_PN, XDR_DECODE);
					break;
				}
				case 'e':
				{
					if((FILE_PE=fopen(argv[i+1],"r+")) == NULL)
					{
						fprintf(stderr,"Error in %s: trying to open %s\n",progname,argv[i+1]);
						exit(-1);
					}
					i++;
					xdrstdio_create(&xdr_in_pe, FILE_PE, XDR_DECODE);
					break;
				}
				case 'o':
				{
					strcpy(prefix,argv[i+1]);
					i++;
					break;
				}
				default:
				{
					fprintf(stderr,"Command line error in %s: type '%s -H' for help\n",progname,progname);
					exit(-1);
				}
			}
		}
		else
		{
			fprintf(stderr,"Command line error in %s: type '%s -H' for help\n",progname,progname);
			exit(-1);
		}
	}

	/* open output files */

	switch(operation)
	{
		case TO_VRT:
		{
			if(got_vert == 'y')
			{
				sprintf(outfile, "%s.v",prefix);
				if((OUT_PV=fopen(outfile,"w")) == NULL)
				{
					fprintf(stderr,"Error opening output files\n");
					exit(-2);
				}
				xdrstdio_create(&xdr_out_pv, OUT_PV, XDR_ENCODE);
			}
			sprintf(outfile,"%s.r",prefix);
			if((OUT_PR=fopen(outfile,"w")) == NULL)
			{
				fprintf(stderr,"Error opening output files\n");
				exit(-2);
			}
			xdrstdio_create(&xdr_out_pr, OUT_PR, XDR_ENCODE);

			sprintf(outfile,"%s.t",prefix);
			if((OUT_PT=fopen(outfile,"w")) == NULL)
			{
				fprintf(stderr,"Error opening output files\n");
				exit(-2);
			}
			xdrstdio_create(&xdr_out_pt, OUT_PT, XDR_ENCODE);
			break;
		}
		case TO_XYZ:
		{
			if(got_vert == 'y')
			{
				sprintf(outfile, "%s.z",prefix);
				if((OUT_PV=fopen(outfile,"w")) == NULL)
				{
					fprintf(stderr,"Error opening output files\n");
					exit(-2);
				}
				xdrstdio_create(&xdr_out_pv, OUT_PV, XDR_ENCODE);
			}

			sprintf(outfile,"%s.n",prefix);
			if((OUT_PR=fopen(outfile,"w")) == NULL)
			{
				fprintf(stderr,"Error opening output files\n");
				exit(-2);
			}
			xdrstdio_create(&xdr_out_pr, OUT_PR, XDR_ENCODE);

			sprintf(outfile,"%s.e",prefix);
			if((OUT_PT=fopen(outfile,"w")) == NULL)
			{
				fprintf(stderr,"Error opening output files\n");
				exit(-2);
			}
			xdrstdio_create(&xdr_out_pt, OUT_PT, XDR_ENCODE);
			break;
		}
		default:
		{
			fprintf(stderr,"Command line error in %s: Operation undefined type '%s -H' for help\n",progname,progname);
			exit(-1);

		}
	}


	/* loop through data sets */

	while((xdr_gethead(&head_pn, &xdr_in_pn) == 1) && (xdr_gethead(&head_pe, &xdr_in_pe) == 1))
	{
		if(got_vert == 'y') /* get vertical component if included */
		{
			if(xdr_gethead(&head_pz, &xdr_in_pz) != 1)
			{
				exit(0);
			}
		}

		/* allocate data space */

		if((data_pn=(float *)calloc((unsigned)(head_pn.record.ndata),sizeof(float))) == NULL)
		{
			fprintf(stderr,"Error allocating space in %s\n",progname);
			exit(-3);
		}
		if((data_pe=(float *)calloc((unsigned)(head_pe.record.ndata),sizeof(float))) == NULL)
		{
			fprintf(stderr,"Error allocating space in %s\n",progname);
			exit(-3);
		}
		if(got_vert == 'y')
		{
			if((data_pz=(float *)calloc((unsigned)(head_pz.record.ndata),sizeof(float))) == NULL)
			{
				fprintf(stderr,"Error allocating space in %s\n",progname);
				exit(-3);
			}
		}

		/* read data */

		if((xdr_getdata(&head_pn,data_pn, &xdr_in_pn)) <= 0)
		{
			fprintf(stderr,"Error reading data in %s\n",progname);
			exit(-4);
		}
		if((xdr_getdata(&head_pe,data_pe, &xdr_in_pe)) <=0)
		{
			fprintf(stderr,"Error reading data in %s\n",progname);
			exit(-4);
		}
		if(got_vert == 'y')
			if((xdr_getdata(&head_pz,data_pz, &xdr_in_pz)) <= 0)
			{
				fprintf(stderr,"Error reading data in %s\n",progname);
				exit(-4);
			}

		/* get azimut and inclinaison of components */
		cmpaz_n=head_pn.extra[15];
		cmpin_n=head_pn.extra[16];
		cmpaz_e=head_pe.extra[15];
		cmpin_e=head_pe.extra[16];

		/* calculate backazimuth */

		if(calculate_bazi == 'y')distaz(head_pn.event.lat,head_pn.event.lon,head_pn.station.slat,head_pn.station.slon,&dist,&azi,&bazi);



		/* calculate scale factors */

		n_scale=(head_pn.station.A0*head_pn.station.DS)/(head_pe.station.A0*head_pe.station.DS);
		e_scale=(head_pe.station.A0*head_pe.station.DS)/(head_pn.station.A0*head_pn.station.DS);

		/* if instruments are deconvolutions ignore response info */

		log_length=strlen(head_pn.record.log);
		log_pt=head_pn.record.log;
		str_out=1;
		for(i=0;(i<log_length-6) && (str_out != 0);i++)
		{
			if(i != 0)log_pt++;
			strncpy(test,log_pt,5);
			str_out=strcmp(test,"instr");
		}
		if(str_out == 0)  /* data was deconvolved */
		{
			n_scale=e_scale=1.0;
			fprintf(stderr,"Data from station %s was deconvolved--Ignoring Instrument response information\n",head_pn.station.code);
		}

		/* rotate data */

			/* set minimum length for all data records */

		ndata=MIN(head_pn.record.ndata,head_pe.record.ndata);
		if(got_vert == 'y')
			ndata=MIN(ndata,head_pz.record.ndata);

		if(operation == TO_XYZ) bazi*=(-1.0);

		flag=0;
		if ((cmpaz_n != 0.)|| (cmpaz_e !=90.)){
			if ((cmpaz_n == 0.)&&(cmpaz_e == 0.)){
				fprintf(stderr,"Azimut of North and East components is 0. Did you check them? \n");
				phi_n=bazi;
				phi_e=bazi;
				e=1.;
				flag=1;
			}
			if (flag == 0) {
	fprintf(stderr,"Component north and Est are rotated: az_n=%f az_e=%f\n",cmpaz_n,cmpaz_e);
	fprintf(stderr,"Back azimut is shifted from %f to take in account these 2 angles \n",bazi);
				phi_n=bazi-cmpaz_n;
				phi_e=bazi-cmpaz_e+90.;
				e=1./((float)(cos((double)phi_e-(double)phi_n)));
			}
		}else
		{
		phi_n=bazi;
		phi_e=bazi;
		e=1.;
		}

		bazi/=DEG_PER_RAD;
		phi_n/=DEG_PER_RAD;
		phi_e/=DEG_PER_RAD;

		cosphi_n=(float)cos((double)phi_n);
		sinphi_n=(float)sin((double)phi_n);
		cosphi_e=(float)cos((double)phi_e);
		sinphi_e=(float)sin((double)phi_e);

		for(count=0;count < ndata; count++)
		{
			temp=-e*(data_pn[count]*cosphi_e+data_pe[count]*sinphi_n*n_scale)*e;
			data_pe[count]=e*(-data_pe[count]*cosphi_n+data_pn[count]*sinphi_e*e_scale)*e;
			data_pn[count]=temp;

			/* data_e is now tangental and data_n is radial if operation=TO_VRT */
		}

		/* reset header values */

		head_pn.record.ndata=head_pe.record.ndata=ndata;
		if(got_vert == 'y')head_pz.record.ndata=ndata;
		switch(operation)
		{
			case(TO_VRT):
			{
				count=strlen(head_pn.station.chan);
				if(count > 0)
				{
					if(isupper(head_pn.station.chan[count-1]))
						head_pn.station.chan[count-1]='R';
					else
						head_pn.station.chan[count-1]='r';
				}
				count=strlen(head_pe.station.chan);
				if(count > 0)
				{
					if(isupper(head_pe.station.chan[count-1]))
						head_pe.station.chan[count-1]='T';
					else
						head_pe.station.chan[count-1]='t';
				}
				break;
			}
			case(TO_XYZ):
			{
				count=strlen(head_pn.station.chan);
				if(count > 0)
				{
					if(isupper(head_pn.station.chan[count-1]))
						head_pn.station.chan[count-1]='N';
					else
						head_pn.station.chan[count-1]='n';
				}
				count=strlen(head_pe.station.chan);
				if(count > 0)
				{
					if(isupper(head_pe.station.chan[count-1]))
						head_pe.station.chan[count-1]='E';
					else
						head_pe.station.chan[count-1]='e';
				}
				break;
			}
		}
		logger("rot;",&head_pn);
		logger("rot;",&head_pe);
		if(got_vert == 'y')logger("rot:",&head_pz);

		/* write output */

		if(got_vert == 'y')
		{
			if(xdr_puthead(&head_pz, &xdr_out_pv) != 1) {
				fprintf(stderr,"Error writing header in %s\n",progname);
				exit(-5);
			}
			if(xdr_putdata(&head_pz,data_pz, &xdr_out_pv) < 0) {
				fprintf(stderr,"Error writing data in %s\n",progname);
				exit(-5);
			}
		}
		if(xdr_puthead(&head_pn, &xdr_out_pr) != 1) {
			fprintf(stderr,"Error writing header in %s\n",progname);
			exit(-5);
		}
		if(xdr_putdata(&head_pn,data_pn, &xdr_out_pr) < 0) {
			fprintf(stderr,"Error writing data in %s\n",progname);
			exit(-5);
		}

		if(xdr_puthead(&head_pe, &xdr_out_pt) != 1) {
			fprintf(stderr,"Error writing data in %s\n",progname);
			exit(-5);
		}
		if(xdr_putdata(&head_pe,data_pe, &xdr_out_pt) < 0) {
			fprintf(stderr,"Error writing data in %s\n",progname);
			exit(-5);
		}

		/* release array space */

		if(got_vert == 'y')cfree((char *)data_pz);
		cfree((char *)data_pe);
		cfree((char *)data_pn);
	}
}



