/*   This program takes a timeseries in "ah" format and tapers the two ends
 * 	by any one of four tapers.
 *			Error conditions are;
 *					-1 = Error in command line input
 *					-2 = Error allocating space for data
 *					-3 = Error reading data from stdin
 *					-4 = Error writing data to stdout
 *
 *			Latest Revision: Nov. 15, 1985
 *				by; Tom Boyd
 *
 *			Updated to Read and Write ah xdr files: Sep. 25, 1989
 *				by; Ken Howard
 *
 */
#include <stdio.h>
#include <rpc/rpc.h>
#include <math.h>
#include "ahhead.h"

char *progname;
main(argc,argv)
	int argc;
	char *argv[];
{
	float *data,percent,x,f;
	ahhed head;
	XDR xdr_in, xdr_out;
	int i,ffl;
	char *calloc(),operation;

	progname=argv[0];
	if((argc<3)||(out_is_tty() != 0)||(in_is_tty()!=0))
	{
		fprintf(stderr,"Usage: %s -[Help] -bphl fraction < stdin > stdout\n\n",progname);
		if(argc >= 2)
		{
		if(*(argv[1]+1) == 'H')
		{
			fprintf(stderr,"-b = bartlett taper (linear)\n");
			fprintf(stderr,"-h = hanning taper (cosine)\n");
			fprintf(stderr,"-p = parzan taper\n");
			fprintf(stderr,"-l = blackman-harris 4 term\n");
			fprintf(stderr,"fraction = decimal fraction of timeseries\n");
			fprintf(stderr,"          to taper on each side\n");
		}
		}
		exit(-1);
	}
	if(*(argv[1]) == '-')
	{
		switch(*(argv[1]+1))
		{
			case 'b':
				operation='b';
				break;
			case 'p':
				operation='p';
				break;
			case 'h':
				operation='h';
				break;
			case 'l':
				operation='l';
				break;
			default:
				fprintf(stderr,"Error in command line to %s: type '%s -H' for help\n",progname,progname);
				exit(-1);
		}
	}
	else
	{
		fprintf(stderr,"Error in command line to %s: type '%s -H' for help\n",progname,progname);
		exit(-1);
	}

	percent=atof(argv[2]);

	if((percent > 1.0) || (percent < 0.0))
	{
		fprintf(stderr,"Error in command line to %s: fraction must be between 0 and 1\n",progname);
	}

	xdrstdio_create(&xdr_in, stdin, XDR_DECODE);
	xdrstdio_create(&xdr_out, stdout, XDR_ENCODE);

	while(xdr_gethead(&head, &xdr_in) == 1)
	{

		/* get data space */

		if((data=(float *)calloc((unsigned)head.record.ndata,sizeof(float))) == NULL)
		{
			fprintf(stderr,"Error allocating space in %s\n",progname);
			exit(-2);
		}

		/* read data */

		if(xdr_getdata(&head,data, &xdr_in) <= 0)
		{
			fprintf(stderr,"Error reading data in %s\n",progname);
			exit(-3);
		}

		/* taper data */

		ffl=(int)(head.record.ndata*percent); /* taper length in samples */

		switch(operation)
		{
			case 'b':  /* bartlett taper */
				for(i=0;i<ffl;i++)
				{
					f=1.0*(float)i/(float)(ffl);
					data[i]*=f;
					data[head.record.ndata-1-i]*=f;
				}
				logger("taper-b;",&head);
				break;
			case 'p': /* parzan taper */
				for(i=0;i<ffl;i++)
				{
					x=1.0*(float)i/(float)(ffl+1);
					if(x-0.5 <= 0)
					{
						f=6.0*x*x-6.0*x*x*x;
					}
					else
					{
						f=1.0-2.0*pow((double)(1.0-x),(double)3.0);
					}
					data[i]*=f;
					data[head.record.ndata-1-i]*=f;
				}
				logger("taper-p;",&head);
				break;
			case 'h': /* hanning taper */
				for(i=0;i<ffl;i++)
				{
					f=0.5-0.5*cos(3.1415926*(float)(i)/(float)(ffl+1));
					data[i]*=f;
					data[head.record.ndata-1-i]*=f;
				}
				logger("taper-h;",&head);
				break;
			case 'l': /* blackmann-harris 4 term taper */
				for(i=0;i<ffl;i++)
				{
					f=0.35825-0.48829*cos(3.1415926*(float)(i)/(float)(ffl+1))+0.14128*cos(2.0*3.1415926*(float)(i)/(float)(ffl+1))-0.01168*cos(3.0*3.1415926*(float)(i)/(float)(ffl+1));
					data[i]*=f;
					data[head.record.ndata-1-i]*=f;
				}
				logger("taper-l;",&head);
		}

		/* write output */

		if(xdr_puthead(&head, &xdr_out) != 1) 
		{
			fprintf(stderr,"Error writing header in %s\n",progname);
			exit(-3);
		}
		if(xdr_putdata(&head,data, &xdr_out) < 0)
		{
			fprintf(stderr,"Error writing data in %s\n",progname);
			exit(-3);
		}

		/* free array space */

		cfree((char *)data);
	}
				
	xdr_destroy(&xdr_in);
	xdr_destroy(&xdr_out);
}

