

#include <stdio.h>
#include <rpc/rpc.h>
#include "ahhead.h"

char	*progname;

main(argc,argv)		/* filter:	ascii -> ah format			*/
int	argc;		/* exits:	0	->	OK			*/
char	**argv;		/*		-1	->	stdout is screen 	*/
			/*		-2	->	unknown data type 	*/
			/*		-3	->	not enough room 	*/
			/*		-4	->	error writing output	*/
 			/*			--witte 	12 june 85 	*/
 			/*							*/
 			/*			--updated to write xdr ah files	*/
 			/*			--ken howard 	26 sept 89	*/
{
	char	buf[81];
	int	i,tempint,end,sw;
	long	nelem;
	float	*data,*dptr,*stop;
	ahhed	ahhead;
	XDR	xdr_out;

	char	*calloc(),*mkdatspace();
	char	*fgets();

	progname= argv[0];
	xdrstdio_create(&xdr_out, stdout, XDR_ENCODE);

	while(strcmp(fgets(buf,80,stdin),"station information\n") == 0)	/* should be "station information\n" */
	{
/* read header info */
/* station info */
	fscanf(stdin,"%*s %[^\n]s",ahhead.station.code);
	fscanf(stdin,"%*s %[^\n]s",ahhead.station.chan);
	fscanf(stdin,"%*s %[^\n]s",ahhead.station.stype);
	fscanf(stdin,"%*s %f",&(ahhead.station.slat));
	fscanf(stdin,"%*s %f",&(ahhead.station.slon));
	fscanf(stdin,"%*s %f",&(ahhead.station.elev));
	fscanf(stdin,"%*s %f",&(ahhead.station.DS));
	fscanf(stdin,"%*s %f",&(ahhead.station.A0));
	fgetc(stdin);
	ignore_line();		/* should be "calibration information\n" */
	ignore_line();		/* should be "pole.re\t\tpole.im\t\tzero.re\t\tzero.im\n" */
/* calibration data */
	for(i=0; i<NOCALPTS; ++i)
		fscanf(stdin,"%f %f %f %f",&(ahhead.station.cal[i].pole.r),&(ahhead.station.cal[i].pole.i),&(ahhead.station.cal[i].zero.r),&(ahhead.station.cal[i].zero.i));

/* event info */
	fgetc(stdin);
	ignore_line();		/* should be "event information\n" */
	fscanf(stdin,"%*s %f",&(ahhead.event.lat));
	fscanf(stdin,"%*s %f",&(ahhead.event.lon));
	fscanf(stdin,"%*s %f",&(ahhead.event.dep));
	fscanf(stdin,"%*s %hd %hd %hd %hd %hd %f",&(ahhead.event.ot.yr),&(ahhead.event.ot.mo),&(ahhead.event.ot.day),&(ahhead.event.ot.hr),&(ahhead.event.ot.mn),&(ahhead.event.ot.sec));
	fscanf(stdin,"%*s %[^\n]s",ahhead.event.ecomment);
/*	fgetc(stdin);
	fgets(ahhead.event.ecomment,80,stdin);	*/

/* record info */
	fgetc(stdin);
	ignore_line();		/* should be "record information\n" */
	fscanf(stdin,"%*s %hd",&(ahhead.record.type));
	fscanf(stdin,"%*s %ld", &(ahhead.record.ndata));
	fscanf(stdin,"%*s %f",&(ahhead.record.delta));
	fscanf(stdin,"%*s %f",&(ahhead.record.maxamp));
	fscanf(stdin,"%*s %hd %hd %hd %hd %hd %f",&(ahhead.record.abstime.yr),&(ahhead.record.abstime.mo),
	&(ahhead.record.abstime.day),&(ahhead.record.abstime.hr),
	&(ahhead.record.abstime.mn),&(ahhead.record.abstime.sec));
	fscanf(stdin,"%*s %f",&(ahhead.record.rmin));
	fscanf(stdin,"%*s %[^\n]s",ahhead.record.rcomment);
/*	fgetc(stdin);
	fgets(ahhead.record.rcomment,80,stdin);		*/
	fscanf(stdin,"%*s %[^\n]s",ahhead.record.log);
/*	fgets(ahhead.record.log,80,stdin);		*/
	if((ahhead.record.type < 0) || (ahhead.record.type > TYPEMAX))
	{
		fprintf(stderr,"%s:  unknown data type\n",progname);
		fprintf(stderr,"%*s %[^\n]s",ahhead.record.type);
		exit(-2);
	}

/* extras */
	fgetc(stdin);
	ignore_line();		/* should be "extras:\n" */
	for(i=0; i<NEXTRAS; ++i)
		fscanf(stdin,"%*s %f",&(ahhead.extra[i]));

/* GET DATA */
	fgetc(stdin);
	ignore_line();		/* should be "data:\n" */

	switch(ahhead.record.type)
	{
	case 0:		/* integer data */
	case 1:		/* floats */
	case 6:		/* doubles */
		nelem= ahhead.record.ndata;
		break;

	case 2:		/* complex */
	case 3:		/* real (x,y) pairs */
		nelem= 2*(ahhead.record.ndata);
		break;

	case 4:		/* x real, y complex */
		nelem= 3*(ahhead.record.ndata);
		break;

	case 5:		/* complex (x,y) pairs */
		nelem= 4*(ahhead.record.ndata);
		break;
	}	/*	end switch(ahhead.record.type) */

	if(ahhead.record.type != 0)
		data= (float *)mkdatspace(&ahhead);
	else		/* handles integer input	*/
	{
		++(ahhead.record.type);
		data= (float *)mkdatspace(&ahhead);
		--(ahhead.record.type);
	}

	(data != NULL) ? (sw= 0) : (sw= 1);

	switch(sw)
	{
	case 0:		/* enough space	*/

		stop= data + nelem;
		if(ahhead.record.type == 0)
		{
			++(ahhead.record.type);
			for(dptr=data; dptr<stop; ++dptr)
			{
				fscanf(stdin,"%d",&tempint);
				*dptr= tempint;
			}
		}
		else
		{
			for(dptr=data; dptr<stop; ++dptr)
				fscanf(stdin,"%f",dptr);
		}
		
		if(xdr_putrecord(&ahhead,(char *)data, &xdr_out) != 0) 
		{
			fprintf(stderr,"%s:  error writing ah record\n",progname);
			exit(-4);
		}
		break;


	case 1:		/* chop into blocks */
		if((data= (float *)calloc((unsigned)BUFSIZ,sizeof(float))) == NULL)
		{
			fprintf(stderr,"%s:  not enough room\n",progname);
			exit(-3);
		}

		end= (int)nelem/BUFSIZ;	/* whole blocks */
		stop= data + BUFSIZ;
		if(ahhead.record.type != 0)
		{
			if(xdr_puthead(&ahhead, &xdr_out) != 1)  
			{
				fprintf(stderr,"%s:  error writing ah header\n",progname);
				exit(-4);
			}
			for(i=0; i<end; ++i)
			{
				for(dptr=data; dptr<stop; ++dptr)
					fscanf(stdin,"%f",dptr);
				if(!xdr_vector(&xdr_out, data, BUFSIZ, sizeof(float), xdr_float)) 
				{
					fprintf(stderr,"%s:  error writing ah data\n",progname);
					exit(-4);
				}
			}

			end= (int)nelem%BUFSIZ;	/* remainder */
			stop= data + end;
			for(dptr=data; dptr<stop; ++dptr)
				fscanf(stdin,"%f",dptr);
			if(!xdr_vector(&xdr_out, data, end, sizeof(float), xdr_float))
			{
				fprintf(stderr,"%s:  error writing ah data\n",progname);
				exit(-4);
			}
		}
		else
		{
			++(ahhead.record.type);
			if(xdr_puthead(&ahhead, &xdr_out) != 1)
			{
				fprintf(stderr,"%s:  error writing ah header\n",progname);
				exit(-4);
			}

			for(i=0; i<end; ++i)
			{
				for(dptr=data; dptr<stop; ++dptr)
				{
					fscanf(stdin,"%d",&tempint);
					*dptr= (float)tempint;
				}
				if(!xdr_vector(&xdr_out, data, BUFSIZ, sizeof(float), xdr_float))
				{
					fprintf(stderr,"%s:  error writing ah data\n",progname);
					exit(-4);
				}
			}

			end= (int)nelem%BUFSIZ;	/* remainder */
			stop= data + end;
			for(dptr=data; dptr<stop; ++dptr)
			{
				fscanf(stdin,"%d",&tempint);
				*dptr= (float)tempint;
			}
			if(!xdr_vector(&xdr_out, data, end, sizeof(float), xdr_float))
			{
				fprintf(stderr,"%s:  error writing ah data\n",progname);
				exit(-4);
			}
		}

		break;
	}	/*	end switch(sw)	*/
	free((char *)data);
	fgetc(stdin);

	if(ungetc(fgetc(stdin),stdin) == EOF)
		exit(0);

}	/*	end while(ignore_line)	*/
exit(-1);	/* something wrong */
}	/*	end main	*/
		


/*	ignore_line
 *		gets the next line (up to and including the newline
 *		character) from  and promptly loses it.  Useful
 *		for skipping lines in an ASCII file.
 */
int	ignore_line()
{
	char	*fgets();
	char	string[256];

	if(fgets(string,250,stdin) == NULL)	/* nothing there	*/
		return(-1);
	return(0);			/* there was something	*/
}
