/*
	This subroutine calculates the filter coefficient for a 1 pole
	butterworth filter at a given complex frequency point

	Inputs;
		freq -> frequency 
		cutoff -> 3db point of filter
		type -> either 'h' or 'l' for high or lowpass

	Outputs;
		out_real out_imag -> real and imaginary component of filter response
*/
but1(freq,out_real,out_imag,cutoff,type)
	float *out_real,*out_imag;
	float cutoff,freq;
	char type;
{
	float p1_real,p1_imag,num_real,num_imag;
	float s_real,s_imag,temp;

	p1_real=cutoff;
	p1_imag=0.0;
	s_real=0.0;
	s_imag=freq;

	if(type == 'l')
	{
		num_real=cutoff;
		num_imag=0.0;
	}
	if(type == 'h')
	{
		num_real=0.0;
		num_imag=freq;
	}

	/* now do cresp=num/(s+p1) */

	p1_real+=s_real;
	p1_imag+=s_imag;

	temp=p1_real*num_real+p1_imag*num_imag;
	num_imag=p1_real*num_imag-p1_imag*num_real;
	num_real=temp;
	temp=p1_real*p1_real+p1_imag*p1_imag;

	num_real/=temp;
	num_imag/=temp;

	(*out_real)=num_real;
	(*out_imag)=num_imag;
}
	
