/*
	This subroutine calculates the filter coefficient for a 2 pole
	butterworth filter at a given complex frequency point

	Inputs;
		freq -> frequency 
		cutoff -> 3db point of filter
		type -> either 'h' or 'l' for high or lowpass

	Outputs;
		out_real out_imag -> real and imaginary components of filter response
*/
but2(freq,out_real,out_imag,cutoff,type)
	float *out_real,*out_imag;
	float cutoff,freq;
	char type;
{
	float p1_real,p1_imag,p2_real,p2_imag;
	float cos_45,sin_45,num_real,num_imag;
	float s_real,s_imag,temp_real,temp;

	cos_45=0.70710678;
	sin_45=0.70710678;
	p1_real=p2_real=cos_45*cutoff;
	p1_imag=sin_45*cutoff;
	p2_imag=(-1.0)*cos_45*cutoff;
	s_real=0.0;
	s_imag=freq;

	if(type == 'l')
	{
		num_real=cutoff*cutoff;
		num_imag=0.0;
	}
	if(type == 'h')
	{
		num_real=(-1.0)*freq*freq;
		num_imag=0.0;
	}

	/* now do cresp=num**2/((s+p1)*(s+p2)) */

	p1_real+=s_real;
	p1_imag+=s_imag;
	p2_real+=s_real;
	p2_imag+=s_imag;

	temp_real=p1_real*p2_real-p1_imag*p2_imag;
	p1_imag=p1_real*p2_imag+p1_imag*p2_real;
	p1_real=temp_real;

	temp_real=p1_real*num_real+p1_imag*num_imag;
	num_imag=p1_real*num_imag-p1_imag*num_real;
	num_real=temp_real;
	temp=p1_real*p1_real+p1_imag*p1_imag;

	num_real/=temp;
	num_imag/=temp;

	(*out_real)=num_real;
	(*out_imag)=num_imag;
}
	
