/*
	This subroutine calculates the filter coefficient for a 3 pole
	butterworth filter at a given complex frequency point

	Inputs;
		freq -> frequency 
		cutoff -> 3db point of filter
		type -> either 'h' or 'l' for high or lowpass

	Outputs;
		out_real out_imag -> real and imaginary components of filter response
*/
but3(freq,out_real,out_imag,cutoff,type)
	float *out_real,*out_imag;
	float cutoff,freq;
	char type;
{
	float p1_real,p1_imag,p2_real,p2_imag,p3_real,p3_imag;
	float cos_60,sin_60,num_real,num_imag;
	float s_real,s_imag,temp_real,temp_imag,temp;

	cos_60=0.5;
	sin_60=0.866025;
	p1_real=p2_real=cos_60*cutoff;
	p1_imag=sin_60*cutoff;
	p2_imag=(-1.0)*sin_60*cutoff;
	p3_real=cutoff;
	p3_imag=0.0;
	s_real=0.0;
	s_imag=freq;

	if(type == 'l')
	{
		num_real=cutoff*cutoff*cutoff;
		num_imag=0.0;
	}
	if(type == 'h')
	{
		num_real=0.0;
		num_imag=(-1.0)*freq*freq*freq;
	}

	/* now do cresp=num**3/((s+p1)*(s+p2)*(s+p3)) */

	p1_real+=s_real;
	p1_imag+=s_imag;
	p2_real+=s_real;
	p2_imag+=s_imag;
	p3_real+=s_real;
	p3_imag+=s_imag;

	temp_real=p1_real*p2_real-p1_imag*p2_imag;
	p1_imag=p1_real*p2_imag+p1_imag*p2_real;
	p1_real=temp_real;

	temp_real=p1_real*p3_real-p1_imag*p3_imag;
	p1_imag=p1_real*p3_imag+p1_imag*p3_real;
	p1_real=temp_real;

	temp_real=p1_real*num_real+p1_imag*num_imag;
	num_imag=p1_real*num_imag-p1_imag*num_real;
	num_real=temp_real;

	temp=p1_real*p1_real+p1_imag*p1_imag;

	num_real/=temp;
	num_imag/=temp;

	(*out_real)=num_real;
	(*out_imag)=num_imag;
}
	
