#include <math.h>
/*
	This subroutine calculates the filter coefficient for a cosine taper
	filter at a given complex frequency point

	Inputs;
		freq -> frequency 
		freq_deb, freq_end begin and end frequency of the taper
		type -> either 'h' or 'l' for high or lowpass

	Outputs;
		out_real out_imag -> real and imaginary component of filter response
*/
costap(freq,out_real,out_imag,freq_deb,freq_end,type)
	float *out_real,*out_imag;
	float freq_deb,freq_end,freq;
	char type;
{
	float f0,num_real,num_imag,deltaf;
	float s_real,s_imag,temp;

	if(type == 'l')
	{
		f0=freq_deb;
		deltaf=freq_end-freq_deb;
	}
	if(type == 'h')
	{
		f0=freq_end;
		deltaf=freq_end-freq_deb;
	}

	/* now do the filtering */
	if( freq < freq_end && freq > freq_deb) { 
		num_real=.5+.5*cos(3.1415926*(freq-f0)/deltaf);
		} else {
		if(type == 'h' && freq >= freq_end) num_real=1.;
		if(type == 'h' && freq <= freq_deb) num_real=0.;
		if(type == 'l' && freq >= freq_end) num_real=0.;
		if(type == 'l' && freq <= freq_deb) num_real=1.;
		}

	(*out_real)=num_real;
	(*out_imag)=0.;
}
	
