
#include	"ahhead.h"
#include	<stdio.h>
#include	<rpc/rpc.h>
#include	<math.h>

char	*progname;
extern	int	ah_errno;

main(ac,av)	/* kludge to demean an ah-format time series */
int	ac;	/*	--witte 18 october 1985	*/
char	**av;
{
	FILE	*file_in;

	FILE	*fopen();

	progname= av[0];
	ah_errno= 0;

	if(ac == 1)	/* no ags: use stdin */
		demean_ah(stdin,stdout);
	else
		while(--ac)
		{
			if((file_in= fopen(*++av,"r")) == NULL)
			{
				fprintf(stderr,"%s: can't open %s\n",progname,*av);
				exit(1);
			}
			else
			{
				demean_ah(file_in,stdout);
				fclose(file_in);
			}
		}
	exit(0);
}


/*	demean_ah
 *		demeans an ah-format type FLOAT data file
 */
demean_ah(file_in,file_out)
	FILE	*file_in,*file_out;
{
	ahhed	h;		/* ah header */
	XDR	xdr_in;		/* xdr input stream */
	XDR	xdr_out;	/* xdr output stream */
	float	mean;
	float	*d;		/* pointer to data */
	long	n;		/* number of data points */
	char	*data;		/* pointer to data */

	char	*mkdatspace();

	xdrstdio_create(&xdr_in, file_in, XDR_DECODE);
	xdrstdio_create(&xdr_out, file_out, XDR_ENCODE);

	while(xdr_gethead(&h, &xdr_in) == 1)
	{
		data= mkdatspace(&h);
		if( data == NULL)
		{
			fprintf(stderr,"%s: not enough memory\n",progname);
			exit(2);
		}
		xdr_getdata(&h,data, &xdr_in);
		if(ah_errno)
			ah_error("demean_ah","",2);

		switch(h.record.type)
		{
		case FLOAT:
			mean= 0.0;
			d=    (float *)data;
			n=    h.record.ndata;
			while(n--)
				mean += (*d++);	/* sum data */
			mean /= h.record.ndata;	/* divide by number of data points */

			d= (float *)data;
			n= h.record.ndata;
			while(n--)
				(*d++) -= mean;	/* subtract mean from data */
			break;
		default:
			fprintf(stderr,"%s: can only demean data type FLOAT\n",progname);
			exit(2);
			break;
		}

/* add program's graffitti */

		if( strlen( h.record.log ) < LOGSIZE - 10 )
			strcat( h.record.log, "demeaned;" );

		xdr_putrecord(&h,data, &xdr_out);
		cfree(data);
	}
	xdr_destroy(&xdr_in);
	xdr_destroy(&xdr_out);

	return;
}
	
		
	
