#include <stdio.h>
#include <stdlib.h>
#include <rpc/rpc.h>
#include <string.h>
#include <math.h>

#include "ahhead.h"
#include "libutil.h"

float square[14410];

main(argc,argv)
int    argc;
char   **argv;

{
        char    progname[120];
        FILE    *file_in;

        float taux=0.95;

/*
        fprintf(stderr, "Enter taux : ");
        fscanf(stdin,"%f ", &taux);
fprintf(stderr,"taux= %f\n",taux);
*/
        taux = atof(argv[argc-1]); argc--;

        strcpy(progname, argv[0]);

        while(--argc)
        {
                if((file_in = fopen(*++argv,"r")) == NULL)
                {
                        fprintf(stderr,"%s:  can't open %s\n",progname,*argv);
                        exit(-2);
                }
                else
                {
                        record2fenetre(file_in,taux);
                        fclose(file_in);
                }
        }
        exit(0);
}



/*record2fenetre
 *finds window corresponding to taux energy
 *returns:
 *     indices
 */

int record2fenetre(file_in,taux)

FILE*file_in;
float taux;
{
    XDR     xdr_in;
    ahhed   head;
    long    nbytes;
    char    *array;

    int     nmax;
    int     n0, n, n1;

    xdrstdio_create(&xdr_in, file_in, XDR_DECODE);
    
    while(xdr_gethead(&head, &xdr_in) > 0)
    {
        nbytes = (head.record.ndata)*size(&head);
        if((array= malloc((unsigned)nbytes)) == NULL)
            exit(-1);                       /* not enough space     */
        xdr_getdata(&head, array, &xdr_in);

        fprintf(stderr,"\nndata:\t%ld\n",head.record.ndata);
        fprintf(stderr,"pas:\t%e\n",head.record.delta);

        n = (int) head.record.ndata;
        n0 = 0;
        nmax = max_train(array, n0, n);
        n1 = isole_train(taux, nmax, n0, n);
        fprintf(stdout,"%d %d\n", nmax-n1, n1*2);
    }
}

int max_train(array,n0,nfin)
char *array;
int n0, nfin;
{
    int   i, nmax = 0;
    float max = 0.;
    float *fptr = (float *) array;

    if(n0 == 0) 
    {
        for(i=n0; i<=nfin; i++)
        {
            if(*fptr > max) 
            {
                nmax = i;
                max = *fptr;
                square[i] = *fptr * *fptr;
            }
            fptr ++;
        }
    }
    return nmax;
}

int isole_train(taux,nmax,ndeb,nfin)
float taux;
int nmax, ndeb, nfin;
{
    float energ0 = 0.;
    float energ = square[nmax];
    float te;
    int   i;
    
    for(i=ndeb; i<=nfin; i++) energ0 += square[i];
    te = taux * energ0;
    i = 0;
    while(energ < te && i < nmax - ndeb && i < nfin - nmax) 
    {
        i++;
        energ += (square[nmax-i] + square[nmax+i]);
    }
    return i;
}
