/*	Subroutine inst_resp takes pole and zero information from an
	ah format file and calulates the real and imaginary instrument
	response.  Procedure is as given in Kanaswich page 271.

	Input parameters:
		head_pt -> pointer to an ah format header
		data_length -> length of time series for which instrument
			       response is needed
		dt	-> sample interval in seconds

	Output paramters:
		response -> pointer to a complex array containing the
			    instrument response. Response starts in postion 
			    one, and space must be calloced in the mainline
		function -> returns the maximum amplitude of the response

*/

float inst_resp (head_pt,response)

ahhed *head_pt;
complex *response;

{

float freq_inc,freq,maxamp=(-1.0);
float nyquist;
int nf,num_poles,num_zeros,i,j,anump;
double save,amp;
d_complex omega,denum,num,temp,gain;

/* get number of poles and zeros from header and calculate frequency interval */

	num_poles=(int)(head_pt->station.cal[0].pole.r);
	num_zeros=(int)(head_pt->station.cal[0].zero.r);

/* check to see if there is calibration information */

	gain.r=(double)(head_pt->station.A0);     /* A0 */
	gain.r*=(double)(head_pt->station.DS);   /* DS */

	if((num_poles == 0) && (num_zeros == 0) && (gain.r == 0.))
	{
		fprintf(stderr,"No calibration information present\n");
		exit(-9);
	}

/*	get nearest power of 2 thats at least twice the data length */

	for(i=1;((int)pow((double)2,(double)i))<(head_pt->record.ndata);++i);
	anump=(int)pow((double)2,(double)(i));

/*	calculate nyquist, number of frequency points, and frequency interval */

	nyquist=1.0/(2.0*(head_pt->record.delta));
	nf=(int)(anump/(2.0)+1);
	freq_inc=nyquist/(float)(nf-1.0);
	gain.i=0.0;

/* loop through frequencies and calculate response */

	for(freq=0.0,j=0;j<nf;freq+=freq_inc,++j)
	{
		omega.i=freq*2.0*3.1415926;	
		omega.r=0.0;
		denum.r=denum.i=num.r=num.i=1.0;

		for(i=1;i<=num_poles;++i)
		{
			/* denum=denum*(omega-pole[i]) */
			temp.r=omega.r-(double)head_pt->station.cal[i].pole.r;
			temp.i=omega.i-(double)head_pt->station.cal[i].pole.i;
			save=denum.r*temp.r-denum.i*temp.i;
			temp.i=denum.r*temp.i+denum.i*temp.r;
			temp.r=save;
			denum.r=temp.r;
			denum.i=temp.i;
		}
		for(i=1;i<=num_zeros;++i)
		{
			/* num=num*(omega-zero[i]) */
			temp.r=omega.r-(double)head_pt->station.cal[i].zero.r;
			temp.i=omega.i-(double)head_pt->station.cal[i].zero.i;
			save=num.r*temp.r-num.i*temp.i;
			temp.i=num.r*temp.i+num.i*temp.r;
			temp.r=save;
			num.r=temp.r;
			num.i=temp.i;
		}
		/* gain*num */
		save=gain.r*num.r;
		num.i=gain.r*num.i;
		num.r=save;

		/* num/denum */
		temp.r=num.r*denum.r+num.i*denum.i;
		temp.i=num.i*denum.r-num.r*denum.i;
		save=denum.r*denum.r+denum.i*denum.i;
		temp.r/=save;
		temp.i/=save;
		response[j].r=temp.r;
		response[j].i=temp.i;

		amp=response[j].r*response[j].r+response[j].i*response[j].i;
		if(amp > maxamp)maxamp=(float)amp;
	}
	maxamp=sqrt(maxamp);
	return(maxamp);
}	
