#include <math.h>
/*
	This subroutine make numerical integration
	filter at a given complex frequency point
*/
integ(intg,om,out_real,out_imag)
	float *out_real,*out_imag, om;
	int intg;
{
	float num_real, num_imag;
	if( om == 0.) {
		num_real=0.;
		num_imag=0.;
	} else {
		if(intg == 1) {
			num_real=0.;
			num_imag=om;
		} 
		if(intg == 2) {
			num_real=-om*om;
			num_imag=0.;
		} 
		if(intg == -1) {
			num_real=0.;
			num_imag=-1/om;
		} 
		if(intg == -2) {
			num_real=-1./om/om;
			num_imag=0.;
		} 
	}
	(*out_real)=num_real;
	(*out_imag)=num_imag;
}
	
