c  This is an "ah" version of the program called 'tidhah'
c  whose original version stands in :
c  /geo4/ipg/ramin/IDA.lec/pitsa/src/mainprog .This program,
c  fits a sum of tidal harmonics (as many as allowed by the
c  record length), and a constant and trend.  the least-square
c  coefficients may then be used to fill gaps in the series, and
c  may be printed out as well (in the form of amplitude and phase,
c  referred to the start time).  if gap-filling is to be done, the
c  series must be real.  the fitted tide may be subtracted out
c  to leave a residual series. this is written to another file. in
c  computing the residual, data in gaps is included, though it is 
c  not used in doing the fit. the removal of the constant and trend
c  from the residual is optional
c   the tidal frequencies used are ordinarily chosen from a list in
c  the data statement, in which they are ranked according to
c  potential amplitude. frequencies chosen by the user may be input also.
c
c    **calls tidnor,chol,recurs,realio
c
c  program changed to fiddle the parameters for ocean loading.
c  done by dca,fkw,tgm   4/24/81
c   reading from edits file added by dca 7/24/81
c   option to output fit instead of residual added by dca 10/1/81
c   optional removal of mean/trend from residual added by dca 11/3/81
c   display modified and input made consistent by dca 12/22/89
c   the "ah" version done by  rn /07/90
c   c-version: 30/07/90 pl
c
      subroutine maree(dat,dat2,dt,nda,ifl1,ifl3,iynme,
     .                 iyntr,ifl4,ifl2,ihc,spc,nsd,f,fc,pour,itrou)
      parameter (ngappar=400)	
      complex ocld,fcdum
      double precision y2(48),arg
      real pour
      dimension f(16),tf(16),a(1156),dat(1),dat2(1)
      dimension fc(34),y(34),no(ngappar+1) 
      dimension tn(2*ngappar+2),s(16),c(16),si(16),ci(16) 
      dimension nhar(2),gap(2,ngappar)
      character*4 rnme(16),rname(16)
      character*1 iynme,iyntr,ifl1,ifl2,ifl4,ihc
c  tidal lines included are, in order:  k1, o1, p1, q1, m1,
c  j1, oo1;  m2, s2, n2, k2, nu2, mu2, l2, t2, 2n2.  semidiurnals
c  and diurnals are scanned separately.
      data tf/1.0027379,.9295357,.99726209,.89324405,.96644626,
     1 1.0390295,1.0759401,1.9322736,2.,1.8959819,2.0054758,
     2 1.9007578,1.8645472,1.9684842,1.99452418,1.8597972/
      data rname/'K1  ','O1  ','P1  ','Q1  ','M1  ','J1  ','OO1 ',
     1 'M2  ','S2  ','N2  ','K2  ','NU2 ','MU2 ','L2  ','T2  ',
     2 '2N2 '/
      data tn(1)/1./,nhar/7,9/,iedf/1/,iedfst/0/,ned/200/ 
c----------------------------------------------------------------
c**** Sample interval
      sam=dt
      sam = sam/86400.
      if(ihc.eq.'n') go to 652
      write(0,*) 'use preselected tidal lines'
      spc = abs(spc)
      go to 2
652   do i = 1,nsd
      	f(i) = 6.283185307*sam*f(i)
      enddo
 2    st = 1
      en = nda  
      write(0,*) nda
      if(st.le.0.or.en.le.0) stop
      rnt = en - st + 1

      if(iedf.lt.0.and.iedfst.eq.1) stop 
c----------------------------------------------------
c***          Traitement des "gap" (trous)      *****
c----------------------------------------------------

      ngp = 0
      k = 0
      if(itrou.eq.1) then	
      do i=1,nda
 	if(dat(i) .eq. 0. .and. k .eq. 0) then
 		k = 1
  		ngp = ngp + 1
 		gap(1,ngp) = i - 1
 	else if(dat(i) .ne. 0. .and. k .ne. 0) then
 		k = 0
 		gap(2,ngp) = i
 	endif
      	if (ngp.gt.ngappar) then
		write(0,*) ' cet enregistrement a trop de gap et n est pas traite'
		return 
      	endif
      enddo
      endif

c*** On recopie les donnees
      do i=1,nda
	dat2(i) = dat(i)
      enddo

      if(ngp .eq. 0) go to 5
      do i=1,ngp
          tn(2*i) = gap(1,i) - st + 1 
     	  tn(2*i+1) = gap(2,i) - st + 1.
      	  write(0,666) gap(1,i)+1, gap(2,i)-1,
     .                      dt*(gap(2,i)-gap(1,i)),i
 666      format(' gap found - ',f7.0,' to ',f7.0,
     .                    ' (sec): ',f7.0,' gap:',i3 )
      enddo
 5    tn(2*ngp+2) = rnt
      write(0,*) 'ngp :',ngp
      ngp = ngp + 1
      tn(2*ngp+1) = 0
      tn(2*ngp+2) = 0


      if(ihc.eq.'n') go to 13

c  scan through harmonics (which are listed in order of potential
c  amplitude for each species), eliminating those too close in frequency
c  to one already chosen
      df = spc/(sam*rnt)
      nsd = 0
      ind = 1
      do i = 1,2
      	if (i.gt.1) ind = ind + nhar(i-1)
      	f(nsd+1) = tf(ind)
      	rnme(nsd+1)=rname(ind)
      	nh = 1
      	do j = 1,nhar(i)-1
      		do   k = 1,nh
      			if(abs(f(nsd+k)-tf(ind+j)).lt.df) go to 9
		enddo
c  harmonic is acceptable
      		f(nsd+nh+1) = tf(ind+j)
      		rnme(nsd+nh+1)=rname(ind+j)
      		nh = nh + 1
 9    	enddo
      	if(i.eq.1) nsds = nh
      	nsd = nsd + nh
      enddo
c  nsd is now the number of harmonics used
c   nsds is the number of diurnals used

 13   do  i = 1,nsd
      	   if(ihc.eq.'y') f(i) = 2.*3.1415926536*sam*f(i)
           ci(i) = cos(f(i))
      	   si(i) = sin(f(i))
      enddo
      write(0,114) nsd, nsds, nsd-nsds
 114  format(1x,i4,' harmonics will be used:',4x,i4,' diurnal,',
     1 i4,' semidiurnal')
      do j = 1,2*nsd+2
      	   y2(j) = 0.
      enddo

c**** modifications. de ramin
      no(1) = 1  
      do j=1,ngp
 	no(j+1) = gap(2,j) 
      enddo
      do i = 1,ngp
         irl = st + tn(2*i-1) - 1
      rf = st + tn(2*i) -1.
 19   irh = min0(irl+59,int(rf))
      np = rf - irl + 1
         nn = no(i) 
c  set up sine and cosine at start point of buffer
 
      	do k = 1,nsd
      		arg = f(k) * nn
      		arg = dmod(arg,6.283185308d0)
      		s(k) = dsin(arg)
      		c(k) = dcos(arg)
 	enddo
c   add terms to right vector
      	do  j = 1,np
      		y2(1) = y2(1) + dat(nn+j)
      		y2(2) = y2(2) + dat(nn+j) * float(tn(2*i-1)+j)
      		do l = 1,nsd
      			y2(2*l+1) = y2(2*l+1) + dat(nn+j)*c(l)
      			y2(2*l+2) = y2(2*l+2) + dat(nn+j)*s(l)
 	enddo
c  recur sine and cosine to next step
      		do l = 1,nsd
      			d = c(l)*ci(l) - s(l)*si(l)
      			s(l) = s(l)*ci(l) + c(l)*si(l)
      			c(l) = d
 		enddo
     	 enddo
      enddo
c*** fin des modifications
c
c  do the inversion
c
      m = 2*nsd + 2
      do i = 1,m
  	    y(i) = y2(i)
      enddo
      call tidnor(a,m,f,nsd,tn,2*ngp)
      call chol(m,a,fc,y,iflag)
      if(iflag.ne.0) stop
c
c  the following section is for ocean loading corrections
c
      if(ifl4.ne.'y') go to 660
      write(0,605)
 605  format(1x,'for the following tidal frequencies type'/
     #1x,'in the admittance amplitude and phase corrections'/)
      do 610 iap=1,nsd
      write(0,615) rnme(iap)
 615  format(3x,a4,': ',$)
      ampl=fc(2*iap+1)
      phas=fc(2*iap+2)
c convert to radians
      phrd=1.74533e-2*phas
      tmprl=ampl*cos(phrd)
      tmpim=ampl*sin(phrd)
      ocld=cmplx(tmprl,tmpim)
      ocld=conjg(ocld)
      fcdum=cmplx(fc(2*iap+1),fc(2*iap+2))
c fiddle coordinates for ocean loading
      fcdum=fcdum*ocld
      fc(2*iap+1)=real(fcdum)
 610  fc(2*iap+2)=aimag(fcdum)
 660  if(ifl3.eq.0.and.(ifl2.eq.'n'.or.ngp.eq.1)) go to 43
c
c  fill the gaps, or subtract out the fitted tides
c
      if(ifl3.ne.0) ngp = 2


      do i = 1,ngp-1
      	irl = tn(2*i) + st 
      	if(ifl3.ne.0) irl = st
      	rf = tn(2*i+1) + st - 2
      	if(ifl3.ne.0) rf = en
 35   	irh = min0(irl+59,int(rf))
c     	np = irh-irl+1
        np = rf - irl +1
	nn = no(i)
c  convert coefficients to their values at start of bad segment,
c  handling the mean and trend as appropriate

      	off = irl -  st + 1
      	con = 0.
      	if(iynme.eq.'y') con = fc(1)
      	slope = 0.
      	if(iyntr.eq.'y') slope = fc(2)
      	con = con + off*slope
      	do j = 1,nsd
      		arg = dble(off)*f(j)
      		sar = dmod(arg,6.28318530717959d0)
      		y(2*j-1) = fc(2*j+1)*cos(sar) + fc(2*j+2)*sin(sar)
      		y(2*j)   = fc(2*j+2)*cos(sar) - fc(2*j+1)*sin(sar)
  	enddo
c---------------------------------------------------------
      	call recurs(dat,np,y,nsd,f,y2)
c---------------------------------------------------------
c   dat now contains the tidal terms - add in the mean and trend
      	do j = 1,np
c		dat(j) = dat(j) + con + slope*float(j-1)
 		dat(j) = dat(j)
      	enddo

      	if(ifl3.lt.0) go to 40

c  prepare to write out residuals or completely fit tide to
c  another file, in which case the output always starts at term 1


	if(pour.eq.0.) then
      	do j = 1,np
       		if(dat2(j) .ne. 0.) then
c      		     dat(j) = dat2(j) - dat(j)
                else if(dat2(j) .eq. 0. .and. itrou.eq.1 ) then
 	             dat(j) =  dat2(j)
                endif
        enddo
	else if(pour.ne.0.) then
      	do j = 1,np
       		if(dat2(j) .ne. 0.) then
      	 	     dat(j) = float(int(dat2(j) - pour*dat(j)))
                else if(dat2(j) .eq. 0. .and. itrou.eq.1) then
 	             dat(j) =  dat2(j)
                endif
	enddo
	endif


c      irl = irh + 1
c     	if(irl.le.rf) go to 35
      enddo
c**** Ecriture des donnees apres ajustement ( ds data)

40    continue

 43   if(ifl1.eq.'n') go to 2
c
c  convert harmonic coefficients to amp and phase, and print out
c   (the convention for phase is that negative phase indicates a
c    lag.  also, the phase is that for the first point.)
 
      do k = 1,nsd
      	y(2*k-1) = sqrt(fc(2*k+1)**2+fc(2*k+2)**2)
      	cp = ci(k)*fc(2*k+1) + si(k)*fc(2*k+2)
      	sp = ci(k)*fc(2*k+2) - si(k)*fc(2*k+1)
      	y(2*k) = 57.2958*atan2(-sp,cp)
      	c(k) = 48.*3.1415926536*sam/f(k)
      enddo
      write(0,118) fc(1),fc(2)
 118  format(' Constant is ',g13.5,' and slope is',g13.5,/)
      write(0,120)
 120  format(10x,'Sym    period     amp        phase  ')
      write(0,122) (rnme(i),c(i),y(2*i-1),y(2*i),i=1,nsds)
 122  format(10x,a4,f8.3,g15.5,1x,f8.2)
      write(0,123)
 123  format(1x)
      write(0,122) (rnme(i),c(i),y(2*i-1),y(2*i),i=nsds+1,nsd)
      write(0,124)
 124  format(/)
	return
      end
