      subroutine tidnor(a,m,fr,nf,tn,ng)
c  forms matrix used for analysing a series in terms of sines, cosines,
c  trend, and constant, using normal equations for least-squares
c  fitting.  series may have gaps.
c      a - matrix returned, dimensioned m by m (m must be even).
c          elements for fitting constant and slope are put in
c          first, then cosine and sine for the frequencies in order.
c      fr - vector of frequencies, normalized so that the nyquist
c           is pi. length is nf.
c      tn - vector of start and end term numbers of data
c           to be analyzed (paired).  number of terms is ng.
c
c
c    **calls function zum (in source file)
c
      complex zum, c, d
      dimension a(m,m), fr(nf),tn(ng)
      ip = 1
      do 1 i = 1,m
      do 1 j = 1,m
 1    a(i,j) = 0.
 2    if(ip.gt.ng) go to 9
      sp = tn(ip) -1
      rp = tn(ip+1) - sp
      a(1,1) = a(1,1) + rp
      a(2,1) = a(2,1) + .5*rp*(rp+2*sp+1)
      a(2,2) = a(2,2) + (rp*(2*rp+1)*(rp+1))/6. + sp*rp*(sp+rp+1)
      do 3 j = 1,nf
      f = fr(j)
      c = 2.*zum(sp,rp,f,0)
      d = zum(sp,rp,f,1) + sp*c
      a(2*j+1,1) = a(2*j+1,1) + real(c)
      a(2*j+2,1) = a(2*j+2,1) + aimag(c)
      a(2*j+1,2) = a(2*j+1,2) + real(d)
      a(2*j+2,2) = a(2*j+2,2) + aimag(d)
 3    continue
      do 7 i = 1,nf
      do 5 j = 1,i
      k = 2*i + 1
      l = 2*j + 1
      f = fr(i)
      g = fr(j)
      c = zum(sp,rp,f+g,0)
      d = zum(sp,rp,f-g+1.e-10,0) 
      a(k,l) = a(k,l) + real(c+d)
      a(k+1,l) = a(k+1,l) + aimag(c+d)
      a(k,l+1) = a(k,l+1) + aimag(c-d)
      a(k+1,l+1) = a(k+1,l+1) - real(c-d)
 5    continue
 7    continue
      ip = ip + 2
      go to 2
 9    do 11 i = 1,m
      do 11 j = 1,i
 11   a(j,i) = a(i,j)
      return
      end
      complex function zum(st,rnt,om,ity)
c  if ity.le.0, returns .5*sum from k = st+1 to st+rnt of exp(i*k*om)
c  if ity.ge.1, returns exp(i*st*om) times sum from k=1 to k=rnt
c     of k*exp(i*k*om)
c  formulae used are modifications (by d agnew) of expressions
c  developed by r l parker
c
c     calls only system routines
c
      complex zd
      double precision a,b,r,tp
      data tp/6.283185307179586/
      r = rnt
      a = .5*om*r
      b = .5*om*(2.d0*st + r)
      if(ity.ge.1) b = a
      c = dmod(a,tp)
      d = dmod(b,tp)
      zd = cmplx(2*(sin(om/2)**2),sin(om))
      zum = -(sin(c)*cmplx(sin(d),-cos(d)))/zd
      if(ity.le.0) return
c  compute more elaborate sum
      zd = conjg(zd)
      a = om*(r + 1.)
      c = dmod(a,tp)
      zum = 2.*zum - rnt*cmplx(cos(c),sin(c))
      zum = zum/zd
      a = dble(st*om)
      c = dmod(a,tp)
      zum = cmplx(cos(c),sin(c))*zum
      return
      end

