!-----------------------------------------------------------
program station_response
!-----------------------------------------------------------
  implicit none
!
  integer :: i,ii,NBT_source,NBT,nbtraces,t,NBT_trace
  doubleprecision    :: bid,dt_source,dt,dt_trace,time,t0
  real :: maxamp
  doubleprecision, dimension(:), allocatable  :: source_orj,source,trace_orj &
                                                ,trace,trace_f
  character(len=30), dimension(:), allocatable::liste_name
  character(len=130) :: response_file
  character(len= 30) :: file_out

!*********************************
  character(len=30) :: realdata,junkb
  integer  :: luin,ib
  integer    :: iyear,im,ij,ihr,imn
  integer    :: iyear1,im1,ij1,ihr1,imn1
  real       ::   sec,sec1
!***********************************


!
  integer :: nz,np,shift,time1
  complex, dimension(:), pointer :: zeros,poles
!
!  maxamp=1.d20
!
! source.gnu
!
  print*,'Entrer dt et NBT:'
  read*,dt,NBT
  allocate(source(NBT),trace(NBT))

!*******************************
   print*,'input the name of read data in format .asc'
   print*, 'for exmple: CAN__VHZ.asc'
   read(*,'(a)') realdata


!*******************************

!  print*,'entre le fichier de reponse:'
!  read(*,'(a)')response_file
      
   response_file=realdata
   
  call get_response(response_file,nz,zeros,np,poles,maxamp)


! call compute_response(nz,zeros,np,poles,nbt,source,dt)
!  reading data
!  open(11,file='data_list.dat',status='old')
!  read(11,*) nbtraces
   
   nbtraces=1
   allocate(liste_name(nbtraces))

!  do i=1,nbtraces
!     liste_name(i)(:)=' '
!     read(11,'(a)') liste_name(i)
!  enddo
!  close(11)
!
!******************************************  
        print*,'input the name of synthetic data to be applied by station response'
        print*, 'for example: UZ__CAN'
        t=1   
        read(*,'(a)') liste_name(t)
!*****************************************

 
     do t=1,nbtraces
     print*,'Filtering trace ',t,liste_name(t)
     open(11,file=liste_name(t),status='old')
     i=0
11   read(11,*,end=101) 
     i=i+1
     goto 11
101  continue  
     NBT_trace=i
     allocate(trace_orj(NBT_trace))
     rewind(11)
     do i=1,NBT_trace
        read(11,*) bid,trace_orj(i)
        if (i==1) then 
           dt_trace=bid
           t0=bid
        endif
        if (i==2) dt_trace=bid-dt_trace
     enddo
     close(11)

!*****************************************
           luin=101
           open(luin,file=realdata,status='old')
           
           do ib=1,45
             read(luin,*)
           enddo 
           read(luin,*) junkb,iyear,im,ij,ihr,imn,sec
           
	    rewind(luin)
            do ib=1,52
             read(luin,*)
           enddo
           read(luin,*) junkb,iyear1,im1,ij1,ihr1,imn1,sec1
           close(luin)

           shift=(imn-imn1)*60+sec-sec1
           print*,'sec=',sec,'sec1=',sec1,'time shift=',shift
           pause
           


!*****************************************

     t0=shift
     call resample(trace_orj,t0,dt_trace,NBT_trace,trace,dt,NBT)
     deallocate(trace_orj)
     call apply_response(nz,zeros,np,poles,nbt,trace,dt)       
!writing
     file_out(:)=' '
     i=LEN_TRIM(liste_name(t))
!     file_out(1+1:i+1)=liste_name(t)(1:i)
!     file_out(i+1:i+3)='_r'
     
     file_out(1:1)='s'
     file_out(2:4)=liste_name(t)(5:7)
     file_out(5:6)=liste_name(t)(3:4)
     file_out(7:8)=liste_name(t)(1:2)
     print*, maxamp 
     open(111,file=file_out,status='unknown')
     do i=1,NBT
     shift=0.d0
         if((i-1)*dt+shift.gt.-1)then
         time1=(i-1)*dt+shift
        write(111,*) time1,trace(i)*maxamp
         endif
     enddo
     close(111)
      print*,'please display the result: xmgr sCAN__UZ '
  enddo
contains
!-----------------------------------------------------------  
  subroutine resample(ya,t0,dta,na,yb,dtb,nb)
!-----------------------------------------------------------  
    use module_spline
    implicit none
    integer            , intent(in) :: na,nb
    doubleprecision, dimension(na), intent(in) :: ya
    doubleprecision               , intent(in) :: dta,dtb,t0
    doubleprecision, dimension(nb), intent(out):: yb
!
    doubleprecision, dimension(na) :: xa,y2
    integer             :: i
    doubleprecision                :: yp1,ypn,x
!
    do i=1,na
       xa(i)=(i-1)*dta+t0
    enddo
    yp1=(ya(2)-ya(1)    )/dta
    ypn=(ya(na)-ya(na-1))/dta
    call spline(xa,ya,yp1,ypn,y2)
    do i=1,nb
       x=(i-1)*dtb
       if (x<=xa(na) .and. x>=xa(1)) then
          yb(i)=splint(xa,ya,y2,x)
       else
          yb(i)=0.0d0
       endif
    enddo
!-----------------------------------------------------------  
  end subroutine resample
!-----------------------------------------------------------  

!-----------------------------------------------------------  
     SUBROUTINE digresp(OM,NZ,Z,NP,P,RESP)
!-----------------------------------------------------------  
       integer, intent(in) :: nz,np
      real, intent(in)       :: om
      complex, intent(out)   :: resp
      complex, dimension(NZ), intent(in)  :: Z
      complex, dimension(NP), intent(in) :: P
      complex :: T,B,O
!
      T=CMPLX(1.,0.)
      B=CMPLX(1.,0.)
      O=CMPLX(0.,OM)
      DO I=1,NZ
         T=T*(O-Z(I))
      enddo
!
      DO I=1,NP
         B=B*(O-P(I))
      end DO
!
      RESP=T/B
!-----------------------------------------------------------  
    end SUBROUTINE digresp
!-----------------------------------------------------------  
!-----------------------------------------------------------
    subroutine get_response(response_file,nz,zeros,np,poles,a0)
!-----------------------------------------------------------
      character(len=130), intent(in) :: response_file
      integer,intent(out) :: nz,np
      complex, dimension(:), pointer :: zeros,poles
      real, intent(out) :: a0
      integer :: i
      real :: r,c,r1,c1
!
!***********************************
   character(len=30) :: realdata,junkb
   integer  :: luin,ib
   integer    :: iyear,im,ij,ihr,imn
   integer    :: iyear1,im1,ij1,ihr1,imn1
   real       ::   sec,sec1
   character(len=50)  :: junk50


!***********************************

           luin=101
           open(luin,file=response_file,status='old')

           do ib=1,7
             read(luin,*)
           enddo
           read(luin,*) junkb,a0
          
           rewind(luin)
            do ib=1,11
             read(luin,*)
            enddo
           read(luin,*) r,c,r1,c1
            nz=r1-1
            np=r
          print*,'a0=',a0,'nz=',nz,'np=',np
          
           allocate(poles(np),zeros(nz))
           rewind(luin)
            do ib=1,12
             read(luin,*)
            enddo
         
	 do i=1,nz
          read(luin,*) r,c,r1,c1
          zeros(i)=cmplx(r1,c1)
         print*,'Zero',i,zeros(i)
         enddo

        rewind(luin)
           do ib=1,12
             read(luin,*)
           enddo
      do i=1,np
         read(luin,*) r,c,r1,c1
         poles(i)=cmplx(r,c)
         print*,'Poles',i,poles(i)
      enddo
      close(luin)

      pause





!***********************************
!      open(13,file=response_file,status='old')
!      read(13,*) a0
!      print*,'Amplification :',a0
!      read(13,'(i2)') nz
!      print*,'nombre de zeros:',nz
!      read(13,'(i2)') np
!      print*,'nombre de poles:',np
!      allocate(poles(np),zeros(nz))
!
!      read(13,*)
!
!      do i=1,nz
!         read(13,'(E14.6,E14.6,E14.6,E14.6)') r,c,r1,c1

!         read(13,*) r,c,r1,c1
!         zeros(i)=cmplx(r1,c1)
!         print*,'Zero',i,zeros(i)
!      enddo
!
!	rewind(13) 
!        read(13,*)
!	read(13,*) 
!        read(13,*)
!
!      do i=1,np
!         read(13,'(E14.6,E14.6,E14.6,E14.6)') r,c,r1,c1
!          read(13,*) r,c,r1,c1
!         poles(i)=cmplx(r,c)
!         print*,'Poles',i,poles(i)
!      enddo
!      close(13)
!-----------------------------------------------------------
    end subroutine get_response
!-----------------------------------------------------------

!-----------------------------------------------------------
    subroutine compute_response(nz,zeros,np,poles,nbt,source,dt)
!-----------------------------------------------------------
      use def_gparam
      implicit none
      integer, intent(in) :: nz,np,nbt
      complex, dimension(nz), intent(in) :: zeros
      complex, dimension(np), intent(in) :: poles
      doubleprecision, dimension(nbt), intent(inout) :: source
      doubleprecision, intent(in) ::dt
!
      real :: df,om,freq
      complex :: resp
      complex*16, dimension(NBT) :: spectre
      integer :: if
!
      df=1./dt/NBT
      do if=1,NBT/2+1     
         om=2.d0*PI*(if-1)*df
         call  digresp(om,nz,zeros,np,poles,resp)
         spectre(if)=resp
         spectre(NBT-if+2)=conjg(resp)
      enddo
      call zfft('C','C','B',spectre,spectre,NBT,1)
      source(:)=0.0d0
      source(:)=real(spectre(:))
      open(14,file='reponse')
      do if=1,NBT
        write(14,*)(if-1)*dt,source(if)
      enddo
      close(14)
!
      
      
!-----------------------------------------------------------
    end subroutine compute_response
!-----------------------------------------------------------
!-----------------------------------------------------------
    subroutine apply_response(nz,zeros,np,poles,nbt,y,dt)
!-----------------------------------------------------------
      use def_gparam
      implicit none
      integer, intent(in) :: nz,np,nbt
      complex, dimension(nz), intent(in) :: zeros
      complex, dimension(np), intent(in) :: poles
      doubleprecision, dimension(nbt), intent(inout) :: y
      doubleprecision, intent(in) ::dt
!
      real :: df,om,freq,om1
      complex :: resp
      complex*16, dimension(NBT) :: spectre
      integer :: if
!
      spectre(:)=y(:)
      call zfft('C','C','F',spectre,spectre,NBT,1)
      df=1./dt/NBT
      do if=1,NBT/2+1     
         om=2.d0*PI*(if-1)*df
         call  digresp(om,nz,zeros,np,poles,resp)
           om1=2.d0*PI*(if-1)*df  
          if (if/=1) then
          spectre(if)=spectre(if)*resp/(cmplx(0.0,om1))
          spectre(NBT-if+2)=spectre(if)*conjg(resp)/(cmplx(0.0,-om1)) 
          else
          spectre(if)=0.d0

          endif

!	  spectre(if)=spectre(if)*resp*(cmplx(0.0,om1))
!          spectre(NBT-if+2)=spectre(if)*conjg(resp)*(cmplx(0.0,om1))

!         spectre(if)=spectre(if)*resp
!         spectre(NBT-if+2)=spectre(if)*conjg(resp)
      enddo
      call zfft('C','C','B',spectre,spectre,NBT,1)
      y(:)=real(spectre(:))
!-----------------------------------------------------------
    end subroutine apply_response
!-----------------------------------------------------------
!-----------------------------------------------------------
  end program station_response
!-----------------------------------------------------------
