c analysis    measurement of phase velocity
c trigon version (not FFT)
c data and synthetic seismograms are read from 2 different input files
c phase velocity is measured by calculating the phase difference
c between data and synthetics seismograms
c   data and seismograms in AH.ascii format !!!!!!!!!!!!!!!!!!!!!!!!!!!
c  This code creates a phase file where the phase is unrolled
c CALCULATION between f_beg and f_end

c sed -e '1,$ s/D/E/' < FCTSl10-500_n0-20.info>toto
c sh  /home/stutz/MINOS/get_vphase_vgroupe.sh < toto> vph_vgrSprem_n0
c--> PHASE VELOCITY CORREPONDING TO THE REFERENCE MODEL
c Last versions: july 2000 (Eleonore Stutzmann), August 2005 (Ylong Qin)
c############################
c INPUT:
c file of data  (ex: KIP_920731541LP_Z.ah)
c file of synthetic seismogram  (ex: syntKIP_920731541LP_Z.ah)
c Vg_min Vg_max nu_of_in (ex: 2.7 5.1  1)
c frq_min frq_max    (ex: 0.0025 0.0333 )
c vph_vgrSprem_n0  file de frq , phase vel., group vel.
c############################
c OUTPUT
c files : sismo1		sismo real
c            sismo2		synthetic seismogram
c            deltavitphas	phase velocity difference with respect to PREM
c            vitphas		
c            phase
c############################

      implicit real*8(a-h,o-z)
c	include '/home/qyl/TD/VPHASE/common_xdrhead'

c     ********************qin yilong
	character*2 junk2
	character*4 junk4
	character*5 junk5
	character*6 junk6
	character*7 junk7
	character*8 junk8
	character*9 junk9 
	character*10 junk10
	character*11 junk11
	character*12 junk12
	character*13 junk13
	character*14 junk14
	character*15 junk15 
c     ********************qin yilong

      character*100 fname,fname1,nom1
      character*1 mode,comp
      character*6  chan,rname,rnmins
      character*6  chan1,rname1,rnmins1
      real*4 alat,alon,stel,sd,pas
      real*4 thes2,phis,dep,sec
      real*4 M11,M22,M33,M12,M13,M23
      real*4 sptm1,stk1,dip1,slp1,amo1
      real*4 alat1,alon1,stel1,sd1,pas1
      real*4 thes21,phis1,dep1,sec1
      real*4 M111,M221,M331,M121,M131,M231
      real*4 sptm11,stk11,dip11,slp11,amo11
      real*4 data(15000)
      real*4 syn(15000),time(15000)
      common /moment/ am(6),sptm
      common /disang/dis,azm,bazm
      dimension y(3100),frq(3100)
      dimension dum1(3100),dum2(3100)
      dimension uur1(5),uur2(5),uul1(5),uul2(5)
      dimension amp1(3100),amp2(3100),phs1(3100),phs2(3100)
      dimension ff1(3100),v1(3100),v2(3100),v3(3100)
      data uur1/5.0,4.0,3.8,3.8,3.8/
      data uur2/2.7,3.3,3.35,3.35,3.35/
      data uul1/5.1,4.7,4.8,4.8,4.8/
      data uul2/3.5,4.0,4.2,4.2,4.2/
c
      pi=3.141592653589793d0
      conv=pi/180.0d0
      pi2=2.0d0*pi
      rad=6371.d0
      gchom=rad*pi2



 1	continue

	write(*,*) 'name of data file (instead end)'
	read(*,'(a100)') fname
	if (fname.eq.'end') goto 999
	write(*,*) 'name of synthetic seismogram file'
	read(*,'(a100)') fname1
	write(*,*) 'minimum and maximum group velocity  and number
     $  wavetrain'
	read(*,*) u2,u1,icase
	write(*,*) 'minimal and maximal frequency in Hertz'
	read(*,*) f1,f2
	print*,fname,fname1
        pause

c-------------------------------------------------------

	nom1='vph'
	nl=longue(fname)
	nom1(4:nl)=fname
	open (600,file='sismo1')
	open (650,file='sismo2')
	open (700,file='deltavitphas')
	open (800,file='vitphas')
	open (900,file='phase')
	open(850,file=nom1)
         print*,'nom1==',nom1
         pause
c--------------------------------------------------------
        luin=100
       
        mod=0
	
       open(luin,file=fname,status='old')

		read(luin,*)

		read(luin,401) junk5,rname
 401	    format(a5,1x,a6)

		read(luin,402) junk8,chan
 402	    format(a8,a6)

 		read(luin,403) junk5,rnmins
 403	    format(a5,1x,a6) 
              
 		read(luin,404) junk9,alat
 404	    format(a9,1x,f8.3) 

 		read(luin,405) junk10,alon
 405	    format(a10,1x,f8.3) 

 		read(luin,406) junk10,stel
 406	    format(a10,1x,f8.3) 

 		do i = 1,35
			read(luin,*)
		enddo

		read(luin,407) junk9,thes2
 407	    format(a9,1x,f8.3)
 
 		read(luin,408) junk10,phis
 408	    format(a10,1x,f8.3)

 		read(luin,409) junk6,dep
 409	    format(a6,1x,f8.3)  

		print*, '409'	
 		read(luin,410) junk12,la,lmo,lj,ihd,imd,sd
 410	     format(a12,1x,i4,1x,i1,1x,i2,1x,i1,1x,i2,1x,f8.3) 

		 read(luin,*)
		 read(luin,*)
		 read(luin,*) 

		read(luin,411) junk6,nd
 411	    format(a6,1x,i7)

 	    read(luin,412) junk6,pas
 412	    format(a6,1x,e20.3) 
             
		 read(luin,*) 

		 read(luin,413) junk11,iyear,im,ij,ihr,imn,sec
 413	     format(a11,1x,i4,1x,i1,1x,i2,1x,i1,1x,i2,1x,f8.3) 

		read(luin,*) 
		read(luin,*) 
		read(luin,*) 
		read(luin,*) 

	    read(luin,414) junk2,M11
		read(luin,414) junk2,M22
		read(luin,414) junk2,M33
		read(luin,414) junk2,M12
		read(luin,414) junk2,M13
		read(luin,414) junk2,M23
		read(luin,*)
		read(luin,414) junk2,sptm1
	
 414	    format(a2,1x,e20.3)
 
		do i = 1,14
			read(luin,*)
		enddo

		do i = 1,nd
			read(luin,*) data(i)
		enddo	
 415	    format(e8.3) 

	 	close(luin)
c        ?????????????????????????
	  stk1=1.0
	  dip1=1.0
	  slp1=1.0
	  amo1=1.0

	print*,'file ',fname
       print*,'code, type of channel of the  station ',rname,chan,rnmins
        print*,'coordinates of station',alat,alon,stel
        print*,'coordinates of epicenter',thes2,phis,dep
        print*,'date beginning of record',la,lmo,lj,ihd,imd,sd
        print*,'date earthquake',iyear,im,ij,ihr,imn,sec
        print*,'nb points and dt',nd,pas
        print*,'strike dip slip',stk1,dip1,slp1
        print*,'Seismic moment tensor',M11,M22,M33,M12,M13,M23
        print*,'1/2 duration of source    and   moment',sptm1,amo1
	print*,'rnmins and rnmins1====',rnmins,rnmins1
        print*, (data(i),i=1,10)
	  pause

           
          luin=luin+1
      open(luin,file=fname1,status='old')
          read(luin,427)junk7
 427        format(a7)
          print*, 'station==', junk7
           pause 



          if(junk7.eq.'station') then
                rewind(luin)
		do i = 1,49
			read(luin,*)
		enddo

                read(luin,421) junk6,nd1
 421	    format(a6,1x,i7)

            
 	    read(luin,422) junk6,pas1
 422	    format(a6,1x,e20.3)

             rewind(luin)

                do i = 1,79
			read(luin,*)
		enddo
             
		do i = 1,nd1
			read(luin,*) syn(i)
		enddo

            else
            rewind(luin)
	    i=0
 144           read(luin,*,end=104)
            i=i+1
            go to 144
 104        continue
            rewind(luin)
            nd1=i
           do i = 1,nd1
               read(luin,*) time(i),syn(i)
           enddo
              pas1=abs(time(2)-time(1))
               
          endif
	
          close(luin)
	  print*, 'nd1=',nd1,'pas1=',pas1
	  print*, (syn(i),i=500,510)
 		pause

           rname1=rname
           chan1=chan
           rnmins1=rnmins
           alat1=alat
           alon1=alon
           stel1=stel
           la1=la
           lmo1=lmo
           lj1=lj
           ihd1=ihd
           imd1=imd
           sd1=sd
           thes21=thes2
           phis1=phis
           dep1=dep
           iyear1=iyear       
           im1=im
           ij1=ij
           ihr1=ihr
           imn1=imn
           sec1=sec
c           pas1=pas
c           nd1=nd
           M111=M11
           M221=M22
           M331=M33
           M121=M12
           M131=M13
           M231=M23
           sptm11=sptm1
           stk11=stk1
           dip11=dip1
           slp11=slp1
           amo11=amo1
         



	
	test1=(iyear1-iyear)+(im1-im)+(ij1-ij)+
     *         (ihr1-ihr)+(imn1-imn)+(sec1-sec) 
	if (test1.ne.0.D0) then
		print*,'beginning trace diff. for  earthquake and synt'
		print*,'earthquake',iyear,im,ij,ihr,imn,sec
		print*,'synthe',iyear1,im1,ij1,ihr1,imn1,sec1
	endif
	test2=(la1-la)+(lmo1-lmo)+(lj1-lj)+
     *         (ihd1-ihd)+(imd1-imd)+(sd1-sd)
	if (test2.ne.0.D0) then
 			print*,'To Check'
		print*,'earthquake synthe and real seismogram diff.'
		print*,'earthquake',la,lmo,lj,ihd,imd,sd
		print*,'synthe',la1,lmo1,lj1,ihd1,imd1,sd1
		aa=real((la1-la)+(lmo1-lmo)+(lj1-lj)+(ihd1-ihd)+(imd1-imd))
		if ((aa.eq.0.).and.((sd1-sd).lt.1.)) test2=0.
	endif
	test3=0.D0
c	if (rnmins1.ne.rnmins) then
c	if (((rnmins(1:3).ne.'GSN').and.(rnmins(1:3).ne.'geo'))
c    &		.or.(rnmins1(1:5).ne.'mode0').or.(rnmins1(1:5).ne.'modet')) then
c			test3=1.d0
c			print*,'To Check'
c			print*,'Synthetic seismo is neither GEOS nor modnor GSN Nor mode0:',rnmins,'x',rnmins1,'x'
c	endif
c	endif
 	if (test3.eq.1.d0) print*,'not the same mode for synthe and real'
	test3=0.D0
 


        if(ierr.ne.0) then
                write(*,*) 'closure code of file ',ierr
                goto 7777
        endif
 
        if (rname(4:4).eq.'8') rname(4:4)=' '
        if (rname(4:4).eq.'_') rname(4:4)=' '
        sptm=dble(sptm1)
      ther2=alat
      phir=alon
      rhgt=stel

        print*,'file ',fname,'code canal type ofa station ',rname,chan,rnmins
        print*,'coordinates of station',alat,alon,stel
        print*,'coordinates of epicentre',thes2,phis,dep
        print*,'date beginning record',la,lmo,lj,ihd,imd,sd
        print*,'date earthquake',iyear,im,ij,ihr,imn,sec
        print*,'nb points and dt',nd,pas
        print*,'strike dip slip',stk1,dip1,slp1
        print*,'Seismic moment tensor',M11,M22,M33,M12,M13,M23
        print*,'1/2 duration of source    and   moment',sptm,amo1
	print*,'rnmins and rnmins1',rnmins,rnmins1
	if (abs(test2).lt.0.0001) test2=0.
	if ((test1.ne.0.).or.(test2.ne.0.).or.(test3.ne.0.)) then
	print*,'test1=',test1,'test2=',test2,'test3=',test3
		goto 999
	endif

c----------------------------------------------------
      sec=sec+sptm

c input above is in (lat., lon.). here change it to colatitude.
      thes=90.0-dble(thes2)
      sthe=dble(thes)*conv
      sphi=dble(phis)*conv

      ther=90.0-ther2
      rthe=ther*conv
      rphi=phir*conv
 
      dt=pas
      nd=npoint
      ti= (sd-sec)+60.*(imd-imn)+3600.*(ihd-ihr)
	if ((ij-lj).gt.0) ti=ti+24*3600*(lj-ij)
c ------------------------------------------------------------

	print*,'group vel',u1,u2
	comp=chan(1:1)
	if((comp.eq.'H').and.(chan(1:3).eq.'HGL')) comp='L'
	if (chan(2:2).eq.'H') comp=chan(3:3)
        if(comp.eq.'T'.or.comp.eq.'t')then
            mode='T'
          else
	    mode='S'
        endif
      if(comp.eq.'Z') mode='S'
      if(comp.eq.'L') mode='S'
      if(comp.eq.'R') mode='S'
      if(comp.eq.'T') mode='T'
      if(comp.eq.'z') mode='S'
      if(comp.eq.'r') mode='S'
      if(comp.eq.'l') mode='S'
      if(comp.eq.'t') mode='T'
	print*,'comp=',comp,' mode=',mode,'chan=',chan
          pause
c
      call readgvel(mode)
         pause
c
c
c
c     calculation of epicentral distance for a sphere (cas synth.)
      pp=dcos(sthe)*dcos(rthe)+dsin(sthe)*dsin(rthe)*dcos(sphi-rphi)
      dis=dacos(pp)
      print*,'dis in spherical case',dis
      dishom=rad*dis

c distance in the spherically symmetric case (for synthetics)
c
	stalat=dble(thes2)
	stalong=dble(phis)
	eplat=dble(ther2)
	eplong=dble(phir)
      call great(stalat,stalong,eplat,eplong,dist1,disd,gc,fai1,fai2)
      fai1= -fai1
      fai2= -fai2
c
      if(icase.eq.1) ngc=1
      if(icase.eq.2) ngc=2
      distn=(ngc/2)*gc+(-1)**(ngc-1)*dist1
c ellipticity correction
      disth=(ngc/2)*gchom+(-1)**(ngc-1)*dishom
      dddl=distn-disth
 	print*,'distance ',distn,disth
c
      t1=distn/u1
      t2=distn/u2
      n0=(t1-ti)/dt
      n1=(t2-t1)/dt
      ts=n0*dt+ti
	print*,'t1 t2 ti dt n0 n1',t1,t2,ti,dt,n0,n1
c
      do 1020 i=1,n1
      dum1(i)=data(n0+i)
      dum2(i)=syn(n0+i)
 1020 continue
	do i=1,n1
	write(600,*) real(i)*dt,real(dum1(i))
	write(650,*) real(i)*dt,real(dum2(i))
	enddo
c	f1=0.019
c	f2=0.04
c      f1=0.0025
c      f2=0.0333
      nfr=101
      nfr=2001
	print*,'number of points in time',n1
	print*,'number of points in frequency',nfr
      df=(f2-f1)/(nfr-1)
      call tspect(n1,dt,dum1,nfr,f1,f2,frq,amp1,phs1)
      call tspect(n1,dt,dum2,nfr,f1,f2,frq,amp2,phs2)

	print*,'data:'
      call drum(nfr,phs1)
	print*,'synthe:'
      call drum(nfr,phs2)
	if ((phs1(1)-phs2(1)).gt.pi) then
		do kk=1,nfr
			phs2(kk)=phs2(kk)+2*pi
		enddo
		print*,'ATTENTION PHASE +2*PI PB IN DRUM'
	endif
	if ((phs2(1)-phs1(1)).gt.pi) then
		do kk=1,nfr
			phs2(kk)=phs2(kk)-2*pi
		enddo
		print*,'ATTENTION PHASE -2*PI PB IN DRUM'
	endif
      call drum1(nfr,phs1)
      call drum1(nfr,phs2)
c
      do 1200 i=1,nfr
      fff=f1+(i-1)*df
      call gtgvel(rnmins,fff,ug,vph)
c vph= theoretical (reference ) velocity
      tell=dddl/ug
      phiell=pi2*fff*tell
c
      xx=phs2(i)-phs1(i)-phiell
      y(i)=xx
c
      tref=disth/vph
      tdev=xx/(pi2*fff)
      tfrac=tdev/tref
      vdev=disth/(tref+tdev)-vph
c     write(6,9510)fff,phs1(i),phs2(i),xx,vph,vdev
c	vdev+vph =actual velocity   vdev=actual vel. - ref. vel. (here prem)  
      ff1(i)=fff
      v1(i)=vph
      v2(i)=vdev
      v3(i)=vdev+vph
 9510 format(f10.6,3f10.5,2e15.7)
 1200 continue
	do i=1,nfr,5
	write(800,111) (ff1(i)),(v1(i)),(v3(i))
	write(700,111) (ff1(i)),(v2(i))
	write(900,*) (ff1(i)),(phs1(i)),(phs2(i))
	enddo
	write(700,*)

	do i=1,nfr,5
	write(850,111) (ff1(i)), (v3(i))
	enddo

	write(*,*) 'xmgr -nxy phase'
	write(*,*) 'xmgr -nxy vitphas'
	write(*,*) 'xmgr deltavitphas'
	write(*,*) 'xmgr sismo1'
	write(*,*) 'xmgr sismo2'

 111  format (e11.4,2(3x,f8.5))
	close(600)
	close(650)
	close(700)
	close(800)
	close(900)
	close(850)
      go to 1
  999 continue
 7777 continue
      stop
      end
c------------------------------------------------------------
      subroutine fft(n,x,aind)
      implicit real*8(a-h,o-z)
c ind = -1 fourier transform
c ind = +1 inverse fourier transform
      complex*16 x(*),u,ang
      j=1
      pi=3.141592653589793d0
      do 30 i=1,n
      if(i.ge.j) go to 10
      u=x(j)
      x(j)=x(i)
      x(i)=u
   10 m=n/2
   20 if(j.le.m) go to 30
      j=j-m
      m=m/2
      if(m.ge.2) go to 20
   30 j=j+m
      kmax=1
   50 if(kmax.ge.n) return
      istp=kmax*2
      do 60 k=1,kmax
      ang=dcmplx(0.0,aind*pi*(k-1)/(kmax))
      do 60 i=k,n,istp
      j=i+kmax
      u=x(j)*cdexp(ang)
      x(j)=x(i)-u
      x(i)=x(i)+u
   60 continue
      kmax=istp
      go to 50
      end
c
c
      subroutine great(alat1,alon1,alat2,alon2,dist,disd,gc,
     *  az12,az21)
c calculation of distance in km and in deg, length of great circle path,
c and azimuth
c  input (lat1,lon1) (lat2,lon2)
c  output	odist : distance in km
c		odisd : distance in degree
c		ogc   : length of great circle path
c		oz12  : azimuth of 2 at 1 measured clockwise from north
c		oz21  : azimuth of 1 at 2
      implicit real*8 (a-h,o-z)
       ath=6378.140
      bth=6356.755
      pi = 3.141592653589793d0
      rad = pi/180.
      h = 1. - bth*bth/(ath*ath)
      p = h/(1. - h)
      gr = alon1*rad
      tr = alat1*rad
      sintr =dsin(tr)
      costr =dcos(tr)
      if (sintr .eq. 0.) sintr = .00000100
      if (costr .eq. 0.) costr = .00000100
      r1 = ath/dsqrt(1. - h*sintr*sintr)
      z1 = r1*(1. - h)*sintr
      g = alon2*rad
      t = alat2*rad
      if (t .eq. 0.) t = .0000100
      sint =dsin(t)
      cost =dcos(t)
      r2 = ath/dsqrt(1. - h*sint*sint)
      dg = g - gr
      cosdg =dcos(dg)
      sindg =dsin(dg)
      dgr = gr - g
      dt = t - tr
      q = sint*costr/((1. + p)*cost*sintr) + h*r1*costr/(r2*cost)
      x = r2*cost*cosdg
      y = r2*cost*sindg
      z = r2*(1. - h)*sint
      az12 =datan2(sindg,(q - cosdg)*sintr)
      q = sintr*cost/(costr*sint*(1. + p)) + h*r2*cost/(r1*costr)
      az21 = datan2(dsin(dgr),sint*(q-dcos(dgr)))
      cos12 =dcos(az12)
      cta2 = costr*costr*cos12*cos12
      p0 = p*(cta2 + sintr*sintr)
      b0 = (r1/(1. + p0))*dsqrt(1. + p*cta2)
      e0 = p0/(1. + p0)
      gc = 2.*pi*b0*dsqrt(1. + p0)*(1. - e0*(.25 + e0*(3./64.
     *                                          + 5.*e0/256.)))
      c0 = 1. + p0*(.25 - p0*(3./64. - 5.*p0/256.))
      c2 = p0*(-.125 + p0*(1./32. - 15.*p0/1024.))
      c4 = (-1./256. + 3.*p0/1024.)*p0*p0
      u0 =datan2(sintr,costr*cos12*dsqrt(1. + p0))
      u =datan2(r1*sintr + (1. + p0)*(z - z1),(x*cos12 - y*sintr*
     *                                       dsin(az12))*dsqrt(1. + p0))
      disd = u - u0
      if (u .lt. u0) disd = pi + pi + disd
      dist = b0*(c0*( disd ) +c2*(dsin(u + u) -dsin(u0 + u0))
     *                       +c4*(dsin(4.*u) -dsin(4.*u0)))
      disd = disd/rad
      az12 = az12/rad
      az21 = az21/rad
      if (az12 .lt. 0.) az12 = 360. + az12
      if (az21 .lt. 0.) az21 = 360. + az21
      return
      end
c
      subroutine tspect(n1,dt,dum,nf,f1,f2,fr,am,ph)
c use a recursion formula for Fourier transformation
c subroutine dtrd, taper and trigon are called
c note that we use the definition of
c   F(w)= int  f(t)*exp(-iwt) dt   (negative iwt)
      implicit real*8(a-h,o-z)
      dimension dum(*),fr(*),am(*),ph(*),y(3100),yy(3100)
      data begin/0.25d0/,end/0.25d0/
c
      call dtrd(dum,n1,y,1)
      call taper(y,n1,begin,end,yy)
      df=(f2-f1)/(nf-1)
      do 10 i=1,nf
      f=f1+(i-1)*df
      fnd=f*dt
      call trigon(yy,n1,fnd,c,s)
      am(i)=dsqrt(c*c+s*s)*dt
      ph(i)=0.0d0
      if(c.ne.0.0d0) ph(i)=datan2(-s,c)
      fr(i)=f
   10 continue
c
      return
      end
c
      subroutine trigon(x,n,f,c,s)
      implicit real*8(a-h,o-z)
      dimension x(*)
c
      n1=n-1
      w=f*2.0d0*3.141592653589793d0
      cw=dcos(w)
      sw=dsin(w)
      cw2=2.0d0*cw
      v=0.0d0
      vv=0.0d0
      k=n
      c=0.0d0
      s=0.0d0
      if(n1) 4,3,1
    1 do 2 i=1,n1
      vvv=vv
      vv=v
      v=x(k)+vv*cw2-vvv
    2 k=k-1
    3 c=x(1)+v*cw-vv
      s=v*sw
    4 return
      end
c
      subroutine dtrd (x, n, y, ndeg)
      implicit real*8(a-h,o-z)
      dimension x(*), y(*)
      an = n
      s1 = 0.0
      s2 = 0.0
      if(ndeg) 11, 11, 20
   11 do 12 i=1,n
   12 s1 = s1+x(i)
      avex = s1/an
      do 15 i=1,n
   15 y(i) = x(i) - avex
      return
   20 do 22 i=1,n
      s1 = s1+x(i)
   22 s2 = s2 + s1
      avei = 0.5 * (an+1.0)
      avex = s1/an
      slope = -12.0*(s2-avei*s1)/(an*(an**2-1.0))
      do 28 i=1,n
      ai = i
   28 y(i) = x(i)-avex-slope*(ai-avei)
      return
      end
      subroutine taper (a, n, start, end, b)
      implicit real*8(a-h,o-z)
      dimension a(*), b(*)
      pi=3.141592653589793d0
      an = n
      m1 = an*start+0.5d0
      m2 = m1 + 1
      if(m1) 10, 10, 11
   11 ang = pi / (m1)
      do 12 i=1, m1
      xi = i
      cs = (1.0d0-dcos(xi*ang))/2.0d0
   12 b(i) = a(i)*cs
   10 m3 = an*end+0.5d0
      m5 = n-m3
      m4 = m5 + 1
      if(m3) 13, 13, 14
   14 ang = pi /  (m3)
      do 15 i=m4,n
      xi = i-n-1
      cs = (1.0d0-dcos(xi*ang))/2.0d0
   15 b(i) = a(i)*cs
   13 do 16 i=m2, m5
   16 b(i) = a(i)
      return
      end
c--------------------------------------------------
      subroutine readgvel(mode)
      implicit real*8(a-h,o-z)
        character*1 mode
	character*80 name,nameph
	character aa*3,aa1*30
	common /gvel1/frg(1400,5),gvel(1400,5),frp(1400,5),
     $        pvel(1400,5),nfrqg(5),nfrqp(5)
	if (mode.eq.'S') then
c       	name='vgrSprem_n0_10_470'
c       	nameph='vphSprem_n0_10_470'
		write(*,*)
c		write(*,'(a)') 'name of phase velocity file correspondant au synthetic'
c		write(*,'(a)') 'e.g. vphSprem_n0_10_470'
c		read(*,'(a)') nameph
c		write(*,'(a)') nameph
c		write(*,'(a)') 'name of group velocity file corresponding to synthetic seismogram'
c		write(*,'(a)') 'e.g. vgrSprem_n0_10_470'
c		read(*,'(a)') name
c		write(*,'(a)') name

	write(*,'(a)') 'name of phase and group velocity file corresponding to synthetic'
 		write(*,'(a)') 'e.g. vph_vgrSprem_n0'
		write(*,*) 'obtained with ~stutz/MINOS/get_vphase_vgroupe.sh'
 		read(*,'(a)') name
c test yann
  	endif


	if (mode.eq.'T') then
c     	name='vgrTpremn0-10'
c     	nameph='vphTpremn0-10'
	write(*,'(a)') 'name of phase and group velocity files  corresponding to synthetic'
 		write(*,'(a)') 'e.g. vgrTprem_n0'
		write(*,*) 'obtained with ~stutz/MINOS/get_vphase_vgroupe.sh'
 		read(*,'(a)') name
	endif

	write(*,'(a)') name
c	write(*,'(a)') nameph
	open (13,file=name,status='old')
      rewind 13
	read(13,'(a30)',END=99) aa1
	if (aa1(1:1).eq.'"') then
	nl=longue(aa1)
	read(aa1(4:6),'(i3)') nmode
	read(aa1(7:nl-1),'(i3)') nb
	k=1
	nfrqg(k)=nb
	nfrqp(k)=nb
	 write(*,*) 'mode=',nmode,' nbre de vit',nb,nfrqg(k),nfrqp(k)
	do i=1,nfrqg(k)
 		read(13,*)frg(i,k),pvel(i,k),gvel(i,k)
		frp(i,k)=frg(i,k)
	enddo
	close(13)
	else
		write(*,*) 'problem'
	endif


c IN modele : only n=0
c	do k=1,1
c		read(13,*) nfrqg(k)
c		read(13,*)(frg(i,k),i=1,nfrqg(k))
c		read(13,*)(gvel(i,k),i=1,nfrqg(k))
c	enddo
c      close(13)
c	open (14,file=nameph,status='old')
c      rewind 14
cc IN modele : que n=0
c	do k=1,1
c		read(14,*) nfrqp(k)
c		read(14,*)(frp(i,k),i=1,nfrqp(k))
cc		read(14,*)(pvel(i,k),i=1,nfrqp(k))
c	enddo
c	close (14)
 99      return
      end
c---------------------------------------------------
      subroutine gtgvel(rnmins,f,uu,vp)
      implicit real*8(a-h,o-z)
	common /gvel1/frg(1400,5),gvel(1400,5),
     $          frp(1400,5),pvel(1400,5),nfrqg(5),nfrqp(5)
      character*6 rnmins
	character*6 rnmins1
	rnmins1=rnmins(1:5)
c
	k=1
	if (rnmins1.eq.'mode0') k=1
	if (rnmins1.eq.'modet') k=1
	if (rnmins1.eq.'geo') k=1
	if (rnmins1.eq.'mode1') k=2
	if (rnmins1.eq.'mode2') k=3
	if (rnmins1.eq.'mode3') k=4
	if (rnmins1.eq.'mode4') k=5
c	if (k.eq.0) then
c		write(*,*) 'name of component incorrect',rnmins1
c		write(*,*) 'calculation for fundamental mode'
c		k=1
cc		stop
c	endif

c group velocity
	do  i=1,nfrqg(k)-1
c decreasing order
c		if(f.le.frg(i,k).and.f.gt.frg(i+1,k)) go to 11
c increasing order
		if(f.ge.frg(i,k).and.f.lt.frg(i+1,k)) go to 11
	enddo
      write(*,*) 'warning  group velocity not found for',f,'nb fr=',nfrqg(k)-1
   11 rat=(f-frg(i,k))/(frg(i+1,k)-frg(i,k))
      arat=1.0d0-rat
      uu=arat*gvel(i,k)+rat*gvel(i+1,k)

c phase velocity
	do  i=1,nfrqp(k)-1
cdecreasing order
		if(f.le.frp(i,k).and.f.gt.frp(i+1,k)) go to 12
c increasing order
		if(f.ge.frp(i,k).and.f.lt.frp(i+1,k)) go to 12
	enddo
      write(*,*) 'warning  phase velocity not found for',f,'nb fr=',nfrqp(k)-1
   12 rat=(f-frp(i,k))/(frp(i+1,k)-frp(i,k))
      arat=1.0d0-rat
      vp=arat*pvel(i,k)+rat*pvel(i+1,k)
c
      return
      end
c--------------------------------------------------------------
      subroutine drum(n,ph)
      implicit real*8(a-h,o-z)
      dimension ph(*)
      pi=3.141592653589793d0
      pi2=2.0d0*pi
      pj=0.0d0
      do 40 i=2,n
      if(dabs(ph(i)+pj-ph(i-1))-pi) 40,40,10
   10 if(ph(i)+pj-ph(i-1)) 20,40,30
   20 pj=pj+pi2
	write(*,*) 'jump of +2*pi'
      go to 40
   30 pj=pj-pi2
	write(*,*) 'jump of -2*pi'
   40 ph(i)=ph(i)+pj
      return
      end
c---------------------------------------
      subroutine drum1(n,ph)
      implicit real*8(a-h,o-z)
      dimension ph(*)
      pi=3.141592653589793d0
      pi2=2.0d0*pi
      pj=0.0d0
      do 40 i=2,n
      if(dabs(ph(i)+pj-ph(i-1))-pi/2) 40,40,10
   10 if(ph(i)+pj-ph(i-1)) 20,40,30
   20 pj=pj+pi
	write(*,*) 'try 2: jump of pi'
      go to 40
   30 pj=pj-pi 
	write(*,*) 'try 2:jump of pi'
   40 ph(i)=ph(i)+pj
      return
      end

c----------------------------------------------------
        function longue (string)
c returns the effective length of string excluding trailing blanks,
c usefull for silly treatment of filenames in UNIX
c J. Borsenberger 10/88
        character*(*) string
        l=len(string)
        do i=l,1,-1
                if (string(i:i).ne.' ') go to 10
        enddo
        i=0
10      longue=i
        return
        end


